﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_AdminManage : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? AdminBaseID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true); SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010104", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        AdminBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);
        if (!AdminBaseID.HasValue)
        {
            System.Web.HttpContext.Current.Response.Redirect("ErrorTip.aspx?EMsg=不存在相应数据,请返回重试！");
        }

        if (!IsPostBack)
        {
            tvManage.Nodes.Clear();
            InitTree(tvManage.Nodes, "ParentID = '{" + Guid.Empty + "}' or ParentID Is Null");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    protected void InitTree(TreeNodeCollection Nds, string Where)//用递归方法动态生成节点
    {
        TreeNode tmpNode;
        List<object> _AdminManageBeanList = SnSee.Factory.Factory.AdminManage.SelectList(0, Where, "order by createtime asc");
        if (_AdminManageBeanList != null && _AdminManageBeanList.Count > 0)
        {
            SnSee.Interface.IAdminManageList _IAdminManageList = SnSee.Factory.Factory.AdminManageList;
            AdminManageBean _AdminManageBean = null;
            for (int i = 0; i < _AdminManageBeanList.Count; i++)
            {
                _AdminManageBean = (AdminManageBean)_AdminManageBeanList[i];
                tmpNode = new TreeNode();
                tmpNode.Value = _AdminManageBean.ID.Value.ToString();
                tmpNode.Text = _AdminManageBean.ManageName + " [" + _AdminManageBean.ManageKey + "]";
                tmpNode.NavigateUrl = "javascript:void(0);";
                if (_AdminManageBean != null)
                {
                    AdminManageListBean _AdminManageListBeanList = (AdminManageListBean)_IAdminManageList.Select("AdminManageID = '{" + _AdminManageBean.ID + "}' and AdminBaseID = '{" + AdminBaseID.Value + "}'", false);
                    if (_AdminManageListBeanList != null)
                    {
                        tmpNode.Checked = true;
                    }
                }
                Nds.Add(tmpNode);
                InitTree(tmpNode.ChildNodes, "ParentID='{" + _AdminManageBean.ID.ToString() + "}'");
            }
            _IAdminManageList.Dispose();
        }
    }

    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010103", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！"); SnSee.Factory.Factory.AdminManageList.Delete("AdminBaseID='{" + AdminBaseID.Value + "}'");
        SetAdminManageList(tvManage.Nodes); SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，数据保存成功！", Request.RawUrl);
    }

    private void SetAdminManageList(TreeNodeCollection _TreeNodeCollection)
    {
        if (tvManage.Nodes.Count > 0)
        {
            AdminManageListBean _AdminManageListBean = null;
            for (int i = 0; i < _TreeNodeCollection.Count; i++)
            {
                if (_TreeNodeCollection[i].Checked)
                {
                    _AdminManageListBean = new AdminManageListBean();
                    _AdminManageListBean.AdminBaseID = AdminBaseID;
                    _AdminManageListBean.AdminManageID = SnSee.Tool.ConvertTool.GetGuid(_TreeNodeCollection[i].Value); SnSee.Factory.Factory.AdminManageList.Insert(_AdminManageListBean);
                }

                if (_TreeNodeCollection[i].ChildNodes.Count > 0)
                {
                    SetAdminManageList(_TreeNodeCollection[i].ChildNodes);
                }
            }
        }
    }
}