﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_AdminSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? AdminID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010105", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        ActionType = Request["AC"];

        AdminID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!IsPostBack)
        {
            if (AdminID.HasValue)
            {
                GetAdminData(AdminID.Value);
            }
            rptList_DataBind();
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入指定ID的数据
    /// </summary>
    /// <param name="ID">分类ID</param>
    private void GetAdminData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        AdminBaseBean _AdminBean = (AdminBaseBean)SnSee.Factory.Factory.AdminBase.Select(ID);
        if (_AdminBean != null)
        {
            txtAdminName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_AdminBean.AdminName);
            dropState.SelectedValue = _AdminBean.State.Value.ToString();
        }
    }

    /// <summary>
    /// 载入列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.AdminBase.SelectList(0, "", "Order By CreateTime Desc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcAdminID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcAdminID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010102", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
                if (SnSee.Factory.Factory.AdminBase.Delete(AcAdminID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string AdminName = SnSee.Tool.EncodeTool.HtmlEncode(txtAdminName.Text);
        string AdminPwd = SnSee.Module.Admin.Admin.SetAdminPassword(txtAdminPwd.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        if (!State.HasValue)
        {
            State = 1;
        }

        if (string.IsNullOrEmpty(AdminName) || string.IsNullOrEmpty(AdminPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "管理员名称或管理密码未填写，请核实！");
            return;
        }

        #region 取得系统内置管理员(此管理员拥用系统最高管理权限)
        string SystemManageName = null, SystemManagePassword = null;
        SnSee.Module.Admin.Admin.GetSystemManage(out SystemManageName, out SystemManagePassword);
        #endregion

        if (!string.IsNullOrEmpty(SystemManageName) && AdminName.ToLower() == SystemManageName.ToLower())
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "不能以当前名称为管理员，请更换另一个后重试操作！");
            return;
        }

        string Where = "AdminName='" + AdminName + "'";
        if (AdminID.HasValue)
        {
            Where += " And AdminName<>'" + AdminName + "'";
        }
        AdminBaseBean _AdminBeanCheck = (AdminBaseBean)SnSee.Factory.Factory.AdminBase.Select(Where);
        if (_AdminBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同名称的管理员，请更换另一个后重试操作！");
            return;
        }

        AdminBaseBean _AdminBean = new AdminBaseBean();
        _AdminBean.AdminName = AdminName;
        _AdminBean.AdminPwd = AdminPwd;
        _AdminBean.State = State;

        bool _Return = false;
        if (AdminID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010103", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
            _Return = SnSee.Factory.Factory.AdminBase.Update(_AdminBean, AdminID.Value);
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010101", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
            _Return = SnSee.Factory.Factory.AdminBase.Insert(_AdminBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}