﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Article_ArticleList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private Guid? ArticleClassID;
    private string Keyword;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Article))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0605", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        ArticleClassID = SnSee.Tool.ConvertTool.GetGuid(Request["CID"]);
        Keyword = Request.QueryString["Key"];

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        Where = "ArticleBase.[State]=1 And ArticleClass.[EditionID]='{" + EditionID + "}'";
        if (ArticleClassID.HasValue)
        {
            Where += " And (ArticleClass.ID='{" + ArticleClassID.Value + "}' Or ArticleClass.[DepthPath] Like '%" + ArticleClassID.Value + "%') ";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.EncodeTool.HtmlEncode(Keyword);
            Where += " And ArticleBase.[Title] Like '%" + Keyword + "%'";
        }

        EditionItem1.NavName = "ArticleList";
        EditionItem1.EditionID = EditionID;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value);
            }

            if (ArticleClassID.HasValue)
            {
                dropClass.SelectedValue = ArticleClassID.Value.ToString();
            }
            if (!string.IsNullOrEmpty(Keyword))
            {
                txtKeyWord.Text = Keyword;
            }
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By ArticleBase.SortOrder Asc, ArticleBase.CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        dropClass.DataSource = SnSee.Module.Article.ArticleClassTree.GetClassTreeList(null, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder asc, CreateTime Desc");
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ArticleBase.GetArticleListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }


    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? ArticleBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!ArticleBaseID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://放入回收站
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0602", true);
                ArticleBaseBean _ArticleBaseBean = new ArticleBaseBean();
                _ArticleBaseBean.State = 0;
                if (SnSee.Factory.Factory.ArticleBase.Update(_ArticleBaseBean, ArticleBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，资讯放入回收站成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "资讯放入回收站失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 搜索资讯
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("ArticleList.aspx?EditionID=" + EditionID + "&CID=" + dropClass.SelectedValue + "&Key=" + txtKeyWord.Text);
    }

    /// <summary>
    /// 批量放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0602", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _ArticleBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _ArticleBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得资讯ID

            if (chkSelect.Checked && _ArticleBaseID.HasValue)
            {
                ArticleBaseBean _ArticleBaseBean = new ArticleBaseBean();
                _ArticleBaseBean.State = 0;
                if (!SnSee.Factory.Factory.ArticleBase.Update(_ArticleBaseBean, _ArticleBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选资讯放入回收站成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选资讯放入回收站存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}