﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Controls_EditionItem : System.Web.UI.UserControl
{
    AdminBaseBean _AdminBeanLogin = null;

    /// <summary>
    /// 导航目录(管理文件名所在目录)
    /// </summary>
    private string _NavDir;
    /// <summary>
    /// 导航目录(管理文件名所在目录)
    /// </summary>
    public string NavDir
    {
        set
        {
            _NavDir = value;
        }
        get
        {
            return _NavDir;
        }
    }

    /// <summary>
    /// 导航名称(管理文件名)
    /// </summary>
    private string _NavName;
    /// <summary>
    /// 导航名称(管理文件名)
    /// </summary>
    public string NavName
    {
        set
        {
            _NavName = value;
        }
        get
        {
            return _NavName;
        }
    }

    /// <summary>
    /// 导航Url参数
    /// </summary>
    private string _UrlParameter;
    /// <summary>
    /// 导航Url参数
    /// </summary>
    public string UrlParameter
    {
        set
        {
            _UrlParameter = value;
        }
        get
        {
            return _UrlParameter;
        }
    }

    /// <summary>
    /// 语言版本ID
    /// </summary>
    private Guid? _EditionID;
    /// <summary>
    /// 语言版本ID
    /// </summary>
    public Guid? EditionID
    {
        set
        {
            _EditionID = value;
        }
        get
        {
            return _EditionID;
        }
    }

    /// <summary>
    /// 是否只显示当前ID的语言版本
    /// </summary>
    private bool? _IsViewCellEditionID;
    /// <summary>
    /// 是否只显示当前ID的语言版本
    /// </summary>
    public bool? IsViewCellEditionID
    {
        set
        {
            _IsViewCellEditionID = value;
        }
        get
        {
            return _IsViewCellEditionID;
        }
    }

    /// <summary>
    /// 关系对象ID
    /// </summary>
    private Guid? _ObjectID;
    /// <summary>
    /// 关系对象ID
    /// </summary>
    public Guid? ObjectID
    {
        set
        {
            _ObjectID = value;
        }
        get
        {
            return _ObjectID;
        }
    }


    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        SetItem();
        if (_IsViewCellEditionID.HasValue && _IsViewCellEditionID.Value && _EditionID.HasValue)
        {
            menuItem_DataBind(0, "State=1 And ID='{" + _EditionID.Value + "}'", "Order By SortOrder Asc, CreateTime Asc");
        }
        else
        {
            menuItem_DataBind(0, "State=1", "Order By SortOrder Asc, CreateTime Asc");
        }
    }

    private void SetItem()
    {
        if (SnSee.Config.WebConfig.EditionAdmin && SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            item_Add.Visible = true;
        }
    }

    private void menuItem_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        string LinkUrl = "../";
        if (!string.IsNullOrEmpty(NavDir))
        {
            LinkUrl += NavDir + "/";
        }
        LinkUrl += _NavName + ".aspx?";
        if (_ObjectID.HasValue)
        {
            LinkUrl += "&ID=" + _ObjectID.Value;
        }
        if (!string.IsNullOrEmpty(UrlParameter))
        {
            LinkUrl += "&" + UrlParameter;
        }

        List<object> _ObjectList = SnSee.Factory.Factory.Edition.SelectList(_MaxNum, _Where, _OrderBy);
        if (_ObjectList != null && _ObjectList.Count > 0)
        {
            rptItemList.DataSource = _ObjectList;
            rptItemList.DataBind();

            EditionBean _EditionBean;
            menuItemMore.Items[0].ChildItems.Clear();
            for (int i = 0; i < _ObjectList.Count && i < 12; i++)
            {
                _EditionBean = (EditionBean)_ObjectList[i];
                MenuItem mi = new MenuItem(_EditionBean.EditionName, _EditionBean.ID.Value.ToString(), "", LinkUrl + "&EditionID=" + _EditionBean.ID.Value);
                menuItemMore.Items[0].ChildItems.Add(mi);
            }
        }
    }
}