﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Feedback_Feedback : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? FeedbackBaseID = null;
    protected string Contact;
    protected string CompanyName;
    protected string Tel;
    protected string Email;
    protected string FeedbackBody;
    protected string UserName;
    protected Guid? UserBaseID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Feedback))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0204", true);
        FeedbackBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);
        if (!FeedbackBaseID.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "没有找到相应的反馈信息！", "FeedbackList.aspx");
            return;
        }

        if (!IsPostBack)
        {
            if (FeedbackBaseID.HasValue)
            {
                LoadFeedbackData(FeedbackBaseID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadFeedbackData(Guid FeedbackBaseID)
    {
        FeedbackBaseBean _FeedbackBaseBean = (FeedbackBaseBean)SnSee.Factory.Factory.FeedbackBase.Select(FeedbackBaseID);
        if (_FeedbackBaseBean != null)
        {
            Contact = _FeedbackBaseBean.Contact;
            CompanyName = _FeedbackBaseBean.CompanyName;
            Tel = _FeedbackBaseBean.Tel;
            Email = _FeedbackBaseBean.Email;
            FeedbackBody = _FeedbackBaseBean.Body;
            if (_FeedbackBaseBean.UserBaseID.HasValue)
            {
                UserBaseBean _UserBaseBean = (UserBaseBean)SnSee.Factory.Factory.UserBase.Select(_FeedbackBaseBean.UserBaseID.Value);
                if (_UserBaseBean != null)
                {
                    UserName = _UserBaseBean.UserName;
                    UserBaseID = _UserBaseBean.ID;
                }
            }
        }

        FeedbackRevertBean _FeedbackRevertBean = (FeedbackRevertBean)SnSee.Factory.Factory.FeedbackRevert.Select("FeedbackBaseID='{" + FeedbackBaseID + "}'");
        if (_FeedbackRevertBean != null)
        {
            txtBody.Text = SnSee.Tool.EncodeTool.HtmlDecode(_FeedbackRevertBean.Body);
        }
    }

    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0201", true);
        bool IsInsert = true;
        FeedbackRevertBean _FeedbackRevertBean = new FeedbackRevertBean();
        _FeedbackRevertBean.FeedbackBaseID = FeedbackBaseID;
        _FeedbackRevertBean.Body = SnSee.Tool.EncodeTool.HtmlEncode(txtBody.Text);
        _FeedbackRevertBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        FeedbackRevertBean _FeedbackRevertBeanCheck = (FeedbackRevertBean)SnSee.Factory.Factory.FeedbackRevert.Select("FeedbackBaseID='{" + FeedbackBaseID.Value + "}'");
        if (_FeedbackRevertBeanCheck != null)
        {
            IsInsert = false;
        }

        if (IsInsert && SnSee.Factory.Factory.FeedbackRevert.Insert(_FeedbackRevertBean))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，回复成功！", "FeedbackList.aspx");
        }
        else if (!IsInsert && SnSee.Factory.Factory.FeedbackRevert.Update(_FeedbackRevertBean, _FeedbackRevertBeanCheck.ID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，回复成功！", "FeedbackList.aspx");
        }
    }

}