﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Feedback_FeedbackRecycleList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private string Keyword;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Feedback))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0205", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        Keyword = Request.QueryString["Key"];

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        Where = "FeedbackBase.[State]=0 And FeedbackBase.[EditionID]='{" + EditionID + "}'";
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.EncodeTool.HtmlEncode(Keyword);
            Where += " And (FeedbackBase.[Title] Like '%" + Keyword + "%' Or FeedbackBase.[Body] Like '%" + Keyword + "%')";
        }

        EditionItem1.NavName = "FeedbackRecycleList";
        EditionItem1.EditionID = EditionID;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
            }

            if (!string.IsNullOrEmpty(Keyword))
            {
                txtKeyWord.Text = Keyword;
            }
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By FeedbackBase.CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.FeedbackBase.GetFeedbackListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }


    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Label lblFeedbackRevert = (Label)e.Item.FindControl("lblFeedbackRevert");

            DataRowView dr = (DataRowView)e.Item.DataItem;
            if (dr == null)
            {
                return;
            }

            if (lblFeedbackRevert != null && dr["ID"] != null)
            {
                FeedbackRevertBean _FeedbackRevertBean = (FeedbackRevertBean)SnSee.Factory.Factory.FeedbackRevert.Select("FeedbackBaseID='{" + dr["ID"].ToString() + "}'");
                if (_FeedbackRevertBean != null)
                {
                    lblFeedbackRevert.Text = SnSee.Tool.StringTool.CutString(_FeedbackRevertBean.Body, 20, true);
                    lblFeedbackRevert.ToolTip = _FeedbackRevertBean.Body;
                }
                else
                {
                    lblFeedbackRevert.Text = "未回复";
                }
            }
        }
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? FeedbackBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!FeedbackBaseID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "canceldelete_command"://还原
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0202", true);
                FeedbackBaseBean _FeedbackBaseBean = new FeedbackBaseBean();
                _FeedbackBaseBean.State = 1;
                if (SnSee.Factory.Factory.FeedbackBase.Update(_FeedbackBaseBean, FeedbackBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，反馈还原成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "反馈还原失败，请重试！", Request.RawUrl);
                }
                break;
            case "delete_command"://彻底删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0202", true);
                if (SnSee.Factory.Factory.FeedbackBase.Delete(FeedbackBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，反馈彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "反馈彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 搜索反馈
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("FeedbackRecycleList.aspx?EID=" + EditionID + "&Key=" + txtKeyWord.Text);
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0202", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _FeedbackBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _FeedbackBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得反馈ID

            if (chkSelect.Checked && _FeedbackBaseID.HasValue)
            {
                if (!SnSee.Factory.Factory.FeedbackBase.Delete(_FeedbackBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选反馈彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选反馈彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}