﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Header : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    protected string AdminName;
    protected Guid AdminBaseID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (_AdminBeanLogin != null)
        {
            AdminName = _AdminBeanLogin.AdminName;
            AdminBaseID = _AdminBeanLogin.ID.Value;
        }
        GetConfig();
        string Where = "(ParentID is null or ParentID='') And State=1";
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Where += " And AdminManageID In(Select AdminManageID From SnSee_AdminManageList Where AdminBaseID='{" + _AdminBeanLogin.ID.Value + "}')";
        }

        rptList_DataBind(0, Where, "Order By SortOrder Asc");
    }

    private void GetConfig()
    {
        litSiteTitle.Text = SnSee.Config.WebConfig.SiteTitle;

        if (SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            hlkAdminPwd.HRef = "SystemConfig/ManagePassword.aspx";
        }
        else
        {
            hlkAdminPwd.HRef = "AdminDetail.aspx";
        }
    }

    private void rptList_DataBind(int MaxNum, string Where, string Order)
    {
        rptList.DataSource = SnSee.Factory.Factory.AdminMenu.SelectList(MaxNum, Where, Order);
        rptList.DataBind();
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            HyperLink hlkMenu = (HyperLink)e.Item.FindControl("hlkMenu");

            AdminMenuBean _AdminMenuBean = (AdminMenuBean)e.Item.DataItem;
            if (_AdminMenuBean != null)
            {
                if (!string.IsNullOrEmpty(_AdminMenuBean.MenuLink))
                {
                    hlkMenu.NavigateUrl = _AdminMenuBean.MenuLink;
                    hlkMenu.Target = "_blank";
                }
                else
                {
                    hlkMenu.Attributes.Add("onclick", "ShowMenu('topMenuName_" + _AdminMenuBean.ID + "')");
                }
            }
        }
    }
}
