﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Info_Info : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private Guid? InfoClassID;
    private string InfoClassKey;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.CompanyInfo))
        {
            SnSee.Module.Admin.Message.AdminErrorTip("该模块尚未开启，如需使用，请联系系统管理员！", "../");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0104", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        InfoClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        InfoClassKey = Request["Key"];

        if (string.IsNullOrEmpty(InfoClassKey))
        {
            SnSee.Module.Admin.Message.AdminErrorTip("企业信息分类标识没有找到，请核实企业信息分类标识是否存在或是否已启用！", "../");
        }

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }
        if (!EditionID.HasValue)
        {
            SnSee.Module.Admin.Message.AdminErrorTip("没有找到可用的语言版本数据，请核实系统语言版本是否存在或是否已启用！", "../");
        }

        InfoClassBean _InfoClassBean = (InfoClassBean)SnSee.Factory.Factory.InfoClass.Select("ClassKey='" + InfoClassKey + "' And State=1");
        if (_InfoClassBean == null)
        {
            SnSee.Module.Admin.Message.AdminErrorTip("企业信息分类标识没有找到，请核实企业信息分类标识是否存在或是否已启用！", "../");
        }

        InfoClassID = _InfoClassBean.ID;
        litTileClass.Text = _InfoClassBean.ClassName;

        ToolMenu1.NavName = "Info";
        EditionItem1.NavName = "Info";
        ToolMenu1.EditionID = EditionID;
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = InfoClassID;
        EditionItem1.UrlParameter = "Key=" + InfoClassKey;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                if (InfoClassID.HasValue)
                {
                    LoadInfo(InfoClassID.Value, EditionID.Value);
                }
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = "：" + _EditionBean.EditionName;
            lbtnOk.Text += "：" + _EditionBean.EditionName;
            lbtnRest.Text += "：" + _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入内容
    /// </summary>
    /// <param name="InfoClassKey">类别Key</param>
    /// <param name="EditionID">版本ID</param>
    private void LoadInfo(Guid InfoClassID, Guid EditionID)
    {
        InfoBaseBean _InfoBaseBean = (InfoBaseBean)SnSee.Factory.Factory.InfoBase.Select("EditionID='{" + EditionID + "}' And InfoClassID='{" + InfoClassID + "}'");
        if (_InfoBaseBean != null)
        {
            txtTitle.Text = _InfoBaseBean.Title;
            txtBody.Value = _InfoBaseBean.Body;
            if (_InfoBaseBean.State.HasValue)
            {
                dropState.SelectedValue = _InfoBaseBean.State.Value.ToString();
            }
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        if (!EditionID.HasValue)
        {
            return;
        }
        if (!InfoClassID.HasValue)
        {
            return;
        }

        string Title = txtTitle.Text;
        string Body = txtBody.Value;
        if (string.IsNullOrEmpty(Body))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入内容！");
            return;
        }

        bool IsAdd = true;
        bool _Return = false;
        Guid InfoID = Guid.Empty;
        InfoBaseBean _InfoBeanCheck = (InfoBaseBean)SnSee.Factory.Factory.InfoBase.Select("EditionID='{" + EditionID.Value + "}' And InfoClassID='{" + InfoClassID.Value + "}'");
        if (_InfoBeanCheck != null)
        {
            InfoID = _InfoBeanCheck.ID.Value;
            IsAdd = false;
        }

        InfoBaseBean _InfoBean = new InfoBaseBean();
        _InfoBean.Title = Title;
        _InfoBean.Body = Body;
        _InfoBean.InfoClassID = InfoClassID;
        _InfoBean.EditionID = EditionID;
        _InfoBean.State = dropState != null && !string.IsNullOrEmpty(dropState.SelectedValue) ? Convert.ToInt32(dropState.SelectedValue) : 0;
        if (IsAdd)
        {
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0101", true);
            _Return = SnSee.Factory.Factory.InfoBase.Insert(_InfoBean);
        }
        else
        {
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0103", true);
            _Return = SnSee.Factory.Factory.InfoBase.Update(_InfoBean, InfoID);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，内容保存成功！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 重置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnRest_Click(object sender, EventArgs e)
    {
        Response.Redirect(Request.RawUrl);
    }
}