﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Join_JoinList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private string Where;
    private int? State;
    private string UserName = "";
    private string ShopAddress = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Join))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0405", true);
        State = SnSee.Tool.ConvertTool.GetInt32(Request.QueryString["State"]);
        UserName = Request.QueryString["UserName"];
        ShopAddress = Request.QueryString["ShopAddress"];

        Where = "1=1 ";
        if (State.HasValue)
        {
            Where += " And [State] =" + State + "";
        }
        if (!string.IsNullOrEmpty(UserName))
        {
            Where += " And [UserName] Like '%" + UserName + "%'";
        }
        if (!string.IsNullOrEmpty(ShopAddress))
        {
            Where += " And [ShopAddress] Like '%" + ShopAddress + "%'";
        }

        if (!IsPostBack)
        {
            if (State.HasValue)
            {
                dropStateSearch.SelectedValue = State.Value.ToString();
            }
            txtUserName.Text = UserName;
            txtShopAddress.Text = ShopAddress;
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.JoinBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? JoinBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!JoinBaseID.HasValue || string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        DropDownList dropState = (DropDownList)e.Item.FindControl("dropState");
        switch (e.CommandName.ToLower())
        {
            case "state_command": SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0403", true);
                if (dropState != null)
                {
                    JoinBaseBean _JoinBaseBean = new JoinBaseBean();
                    _JoinBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
                    if (SnSee.Factory.Factory.JoinBase.Update(_JoinBaseBean, JoinBaseID.Value))
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                    }
                }
                SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            JoinBaseBean _JoinBaseBean = (JoinBaseBean)e.Item.DataItem;
            DropDownList dropState = (DropDownList)e.Item.FindControl("dropState");

            if (dropState != null)
            {
                dropState.SelectedValue = _JoinBaseBean.State.Value.ToString();
            }
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("JoinList.aspx?State=" + dropStateSearch.SelectedValue + "&UserName=" + txtUserName.Text + "&ShopAddress=" + txtShopAddress.Text);
    }

    /// <summary>
    /// 批量处理
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAll_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0403", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _JoinBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _JoinBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _JoinBaseID.HasValue)
            {
                JoinBaseBean _JoinBaseBean = new JoinBaseBean();
                _JoinBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
                if (!SnSee.Factory.Factory.JoinBase.Update(_JoinBaseBean, _JoinBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选项操作成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选项操作失败，请核查后重试！", Request.RawUrl);
        }
    }
}