﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

    public partial class Admin_Join_JoinView : System.Web.UI.Page
    {
        AdminBaseBean _AdminBeanLogin = null;
        private Guid? JoinBaseID;
        protected void Page_Load(object sender, EventArgs e)
        {
            SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
            if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Join))
            {
                Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
            }
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0404", true);
            JoinBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);

            if (!IsPostBack)
            {
                if (JoinBaseID.HasValue)
                {
                    GetJoinBase(JoinBaseID.Value);
                }
            }
            boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
        }

        /// <summary>
        /// 取得加盟信息
        /// </summary>
        /// <param name="ID">加盟信息ID</param>
        private void GetJoinBase(Guid ID)
        {
            JoinBaseBean _JoinBaseBean = (JoinBaseBean)SnSee.Factory.Factory.JoinBase.Select(ID);
            if (_JoinBaseBean != null)
            {
                txtUserName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.UserName);
                if (_JoinBaseBean.Gender.HasValue)
                {
                    rbtnGender.SelectedValue = _JoinBaseBean.Gender.Value.ToString();
                }
                txtAge.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Age);
                txtTelephone.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Telephone);
                txtMobile.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Mobile);
                txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Fax);
                txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Address);
                txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.Email);
                txtPostalCode.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.PostalCode);
                txtShopAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopAddress);
                txtShopAcreage.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopAcreage);
                rbtnShopType.SelectedValue = _JoinBaseBean.ShopType;
                rbtnShopStart.SelectedValue = _JoinBaseBean.ShopStart;
                rbtnShopArea.SelectedValue = _JoinBaseBean.ShopArea;
                rbtnShopOperation.SelectedValue = _JoinBaseBean.ShopOperation;
                txtShopMonthSale.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopMonthSale);
                txtShopMonthPayoff.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopMonthPayoff);
                rbtnShopJoinOrigin.SelectedValue = _JoinBaseBean.ShopJoinOrigin;
                txtShopForecast.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopForecast);
                txtShopExpectations.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopExpectations);
                txtShopAdvantage.Text = SnSee.Tool.EncodeTool.HtmlDecode(_JoinBaseBean.ShopAdvantage);
            }
        }

        protected void btnPost_Click(object sender, EventArgs e)
        {
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0403", true);
            JoinBaseBean _JoinBaseBean = new JoinBaseBean();
            _JoinBaseBean.UserName = SnSee.Tool.EncodeTool.HtmlEncode(txtUserName.Text);
            _JoinBaseBean.Gender = SnSee.Tool.ConvertTool.GetInt32(rbtnGender.SelectedValue);
            _JoinBaseBean.Age = txtAge.Text;
            _JoinBaseBean.Telephone = SnSee.Tool.EncodeTool.HtmlEncode(txtTelephone.Text);
            _JoinBaseBean.Mobile = SnSee.Tool.EncodeTool.HtmlEncode(txtMobile.Text);
            _JoinBaseBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
            _JoinBaseBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
            _JoinBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
            _JoinBaseBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(txtPostalCode.Text);
            _JoinBaseBean.ShopAddress = SnSee.Tool.EncodeTool.HtmlEncode(txtShopAddress.Text);
            _JoinBaseBean.ShopAcreage = SnSee.Tool.EncodeTool.HtmlEncode(txtShopAcreage.Text);
            _JoinBaseBean.ShopType = rbtnShopType.SelectedValue;
            _JoinBaseBean.ShopStart = rbtnShopStart.SelectedValue;
            _JoinBaseBean.ShopArea = rbtnShopArea.SelectedValue;
            _JoinBaseBean.ShopOperation = rbtnShopOperation.SelectedValue;
            _JoinBaseBean.ShopMonthSale = SnSee.Tool.EncodeTool.HtmlEncode(txtShopMonthSale.Text);
            _JoinBaseBean.ShopMonthPayoff = SnSee.Tool.EncodeTool.HtmlEncode(txtShopMonthPayoff.Text);
            _JoinBaseBean.ShopJoinOrigin = rbtnShopJoinOrigin.SelectedValue;
            _JoinBaseBean.ShopForecast = txtShopForecast.Text;
            _JoinBaseBean.ShopExpectations = txtShopExpectations.Text;
            _JoinBaseBean.ShopAdvantage = txtShopAdvantage.Text;

            if (SnSee.Factory.Factory.JoinBase.Update(_JoinBaseBean, JoinBaseID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
            }
        }
    }