﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

using SnSee.Bean;

public partial class Admin_Left : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    Guid? MenuID;
    protected string SystemVersion;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);

        if (Request["ID"] != null)
        {
            MenuID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        }

        string Where = "ParentID is null or ParentID='' And State=1";
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Where += " And AdminManageID In(Select AdminManageID From SnSee_AdminManageList Where AdminBaseID='{" + _AdminBeanLogin.ID.Value + "}')";
        }

        if (!MenuID.HasValue)
        {//如果无菜单ID,则默认载入排首次位菜单
            List<object> _ObjectList = SnSee.Factory.Factory.AdminMenu.SelectList(1, Where, "Order By SortOrder Asc");
            if (_ObjectList != null && _ObjectList.Count > 0)
            {
                AdminMenuBean _AdminMenuBean = (AdminMenuBean)_ObjectList[0];
                MenuID = _AdminMenuBean.ID;
            }
        }

        if (!IsPostBack)
        {
            if (MenuID.HasValue)
            {
                Where = "ParentID='{" + MenuID.Value + "}'and State=1";
                if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
                {
                    Where += " And AdminManageID In(Select AdminManageID From SnSee_AdminManageList Where AdminBaseID='{" + _AdminBeanLogin.ID.Value + "}')";
                }
                rptList_DataBind(0, Where, "Order By SortOrder Asc");
            }
        }
        SystemVersion = SnSee.Module.Systems.Version.GetSystemVersion();
    }

    private void rptList_DataBind(int MaxNum, string Where, string Order)
    {
        rptList.DataSource = SnSee.Factory.Factory.AdminMenu.SelectList(MaxNum, Where, Order);
        rptList.DataBind();
    }

    protected void rptList_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if ((e.Item.ItemType == ListItemType.Item) || (e.Item.ItemType == ListItemType.AlternatingItem))
        {
            TreeView tvMenu = (TreeView)e.Item.FindControl("tvMenu");

            AdminMenuBean _AdminMenuBean = (AdminMenuBean)e.Item.DataItem;
            if (tvMenu != null && _AdminMenuBean != null)
            {
                tvMenu.Dispose();

                string Where = "ParentID='{" + _AdminMenuBean.ID.Value + "}'and State=1";
                if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
                {
                    Where += " And AdminManageID In(Select AdminManageID From SnSee_AdminManageList Where AdminBaseID='{" + _AdminBeanLogin.ID.Value + "}')";
                }
                InitTree(tvMenu.Nodes, Where);
            }
        }
    }

    protected void InitTree(TreeNodeCollection Nds, string Where)//用递归方法动态生成节点
    {
        TreeNode tmpNode;
        List<object> _AdminMenuBeanList = SnSee.Factory.Factory.AdminMenu.SelectList(0, Where, "Order By SortOrder Asc");
        if (_AdminMenuBeanList != null && _AdminMenuBeanList.Count > 0)
        {
            AdminMenuBean _AdminMenuBean = null;
            for (int i = 0; i < _AdminMenuBeanList.Count; i++)
            {
                _AdminMenuBean = (AdminMenuBean)_AdminMenuBeanList[i];
                tmpNode = new TreeNode();
                tmpNode.Value = _AdminMenuBean.ID.Value.ToString();
                tmpNode.Text = _AdminMenuBean.MenuName.ToString();
                if (!string.IsNullOrEmpty(_AdminMenuBean.MenuLink))
                {
                    tmpNode.NavigateUrl = _AdminMenuBean.MenuLink;
                }
                else
                {
                    tmpNode.NavigateUrl = "javascript:void(0)";
                }

                Nds.Add(tmpNode);
                string Where2 = "ParentID='{" + _AdminMenuBean.ID.Value + "}'and State=1";
                if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
                {
                    Where2 += " And AdminManageID In(Select AdminManageID From SnSee_AdminManageList Where AdminBaseID='{" + _AdminBeanLogin.ID.Value + "}')";
                }
                InitTree(tmpNode.ChildNodes, Where2);
            }
        }
    }
}