﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Link_Link : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    protected Guid? LinkBaseID;
    protected Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);

        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Link))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0704", true);

        LinkBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = LinkBaseID;
        EditionItem1.NavName = "Link";

        if (!IsPostBack)
        {
            if (LinkBaseID.HasValue)
            {
                boxDel.Visible = true;
                litTitle.Text = "编辑友情链接";
                EditionItem1.IsViewCellEditionID = true;
                LoadLinkBase(LinkBaseID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入内容
    /// </summary>
    /// <param name="EditionID">版本ID</param>
    /// <param name="LinkID">友情链接ID</param>
    private void LoadLinkBase(Guid LinkBaseID)
    {
        LinkBaseBean _LinkBaseBean = (LinkBaseBean)SnSee.Factory.Factory.LinkBase.Select(LinkBaseID);
        if (_LinkBaseBean != null)
        {
            txtLinkName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_LinkBaseBean.LinkName);
            txtLinkUrl.Text = _LinkBaseBean.LinkUrl;
            txtSortOrder.Text = _LinkBaseBean.SortOrder.HasValue ? _LinkBaseBean.SortOrder.Value.ToString() : "";
            dropState.SelectedValue = _LinkBaseBean.State.HasValue ? _LinkBaseBean.State.Value.ToString() : "0";
            if (_LinkBaseBean.IsImage.HasValue && _LinkBaseBean.IsImage.Value)
            {
                chkIsImage.Checked = true;
                txtImageUrl.Text = _LinkBaseBean.ImageUrl;
                boxImage.Attributes.Remove("style");
            }
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);
        if (!SortOrder.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的排序值不合格，只能输入整数！");
            return;
        }

        string LinkName = SnSee.Tool.EncodeTool.HtmlEncode(txtLinkName.Text);
        bool _Return = true;

        if (string.IsNullOrEmpty(LinkName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未填写友情链接名称！");
            return;
        }

        if (chkIsImage.Checked && string.IsNullOrEmpty(txtImageUrl.Text))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入图片Logo地址！");
            return;
        }

        LinkBaseBean _LinkBaseBean = new LinkBaseBean();
        _LinkBaseBean.LinkName = LinkName;
        _LinkBaseBean.LinkUrl = txtLinkUrl.Text;
        _LinkBaseBean.SortOrder = SortOrder;
        _LinkBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        _LinkBaseBean.EditionID = EditionID;
        _LinkBaseBean.IsImage = chkIsImage.Checked;
        if (chkIsImage.Checked)
        {
            _LinkBaseBean.ImageUrl = txtImageUrl.Text;
        }

        string ReturnText = "";
        if (!LinkBaseID.HasValue)
        {//不存在数据,进行增加
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0701", true);
            if (!SnSee.Factory.Factory.LinkBase.Insert(_LinkBaseBean))
            {
                _Return = false;
            }
            ReturnText = "增加";
        }
        else
        {//已存在数据,进行更新
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0703", true);
            if (!SnSee.Factory.Factory.LinkBase.Update(_LinkBaseBean, LinkBaseID.Value))
            {
                _Return = false;
            }
            ReturnText = "编辑";
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，友情链接" + ReturnText + "成功！", "LinkList.aspx?EID=" + EditionID);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "友情链接" + ReturnText + "失败，请核查后重试！");
        }
    }

    /// <summary>
    /// 当前友情链接放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0702", true);
        if (LinkBaseID.HasValue)
        {
            LinkBaseBean _LinkBaseBean = new LinkBaseBean();
            _LinkBaseBean.State = 0;
            if (SnSee.Factory.Factory.LinkBase.Update(_LinkBaseBean, LinkBaseID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "LinkList.aspx?EditionID=" + EditionID);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "数据错误，无法进行删除！", Request.RawUrl);
        }
    }
}
