﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Link_LinkRecycleList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private string Keyword;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Link))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0705", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        Keyword = Request.QueryString["Key"];

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        Where = "[State]=0 And [EditionID]='{" + EditionID + "}'";
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.EncodeTool.HtmlEncode(Keyword);
            Where += " And [LinkName] Like '%" + Keyword + "%'";
        }

        EditionItem1.NavName = "LinkRecycleList";
        EditionItem1.EditionID = EditionID;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
            }

            if (!string.IsNullOrEmpty(Keyword))
            {
                txtKeyWord.Text = Keyword;
            }
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By SortOrder Asc, CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.LinkBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }


    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? LinkBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!LinkBaseID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "canceldelete_command"://还原
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0702", true);
                LinkBaseBean _LinkBaseBean = new LinkBaseBean();
                _LinkBaseBean.State = 1;
                if (SnSee.Factory.Factory.LinkBase.Update(_LinkBaseBean, LinkBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，友情链接还原成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "友情链接还原失败，请重试！", Request.RawUrl);
                }
                break;

            case "delete_command"://彻底删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0702", true);
                if (SnSee.Factory.Factory.LinkBase.Delete(LinkBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，友情链接彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "友情链接彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 搜索友情链接
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("LinkList.aspx?EditionID=" + EditionID + "&Key=" + txtKeyWord.Text);
    }

    /// <summary>
    /// 批量彻底删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0602", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _LinkBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _LinkBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得友情链接ID

            if (chkSelect.Checked && _LinkBaseID.HasValue)
            {
                if (!SnSee.Factory.Factory.LinkBase.Delete(_LinkBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选友情链接彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选友情链接彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}
