﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Log_SystemException : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private string SystemLogPath = "../SystemLog/";  //系统日志目录
    private DataTable DTLog = null;
    private DateTime? NowLogDay;
    protected string LogFile;
    protected string LogFileMsg;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }

        GetLog();
        rptList_DataBind(LogFile);
        if (!IsPostBack)
        {
            rptLogFileList_DataBind();
        }
    }

    /// <summary>
    /// 载入异常日志数据
    /// </summary>
    private void GetLog()
    {
        DTLog = SnSee.Module.File.FileInfo.GetFileList(SystemLogPath, ".xml");
        if (DTLog != null && DTLog.Rows.Count > 0)
        {
            NowLogDay = SnSee.Tool.ConvertTool.GetDateTime(DTLog.Rows[DTLog.Rows.Count - 1]["FileName"]);
            if (NowLogDay.HasValue)
            {
                cldDate.SelectedDate = NowLogDay.Value.Date;
                LogFile = NowLogDay.Value.Date.ToString("yyyy-MM-dd") + ".xml";
                litTitle.Text = NowLogDay.Value.Date.ToString("yyyy-MM-dd");
            }
        }
    }

    /// <summary>
    /// 判断日期是否存在
    /// </summary>
    /// <param name="_DateTime">对比日期</param>
    /// <returns></returns>
    private bool IsExistDate(DateTime _DateTime)
    {
        if (DTLog != null && DTLog.Rows.Count > 0)
        {
            DateTime? _dt = null;
            for (int i = 0; i < DTLog.Rows.Count; i++)
            {
                if (DTLog.Rows[i]["FileName"] != null)
                {
                    _dt = SnSee.Tool.ConvertTool.GetDateTime(DTLog.Rows[i]["FileName"]);
                    if (_dt.HasValue)
                    {
                        if (_DateTime.Date == _dt.Value.Date)
                        {
                            return true;
                        }
                    }
                }
            }
        }

        return false;
    }

    protected void cldDate_DayRender(object sender, System.Web.UI.WebControls.DayRenderEventArgs e)
    {
        if (IsExistDate(e.Day.Date))
        {
            e.Cell.Font.Bold = true;
            e.Cell.ToolTip = "当前日期有异常日志";
        }
    }

    protected void cldDate_SelectionChanged(object sender, EventArgs e)
    {
        litTitle.Text = cldDate.SelectedDate.ToString("yyyy-MM-dd");
        rptList_DataBind(cldDate.SelectedDate.ToString("yyyy-MM-dd") + ".xml");
    }

    /// <summary>
    /// 载入当前版本产品分类列表
    /// </summary>
    private void rptList_DataBind(string _LogFile)
    {
        if (string.IsNullOrEmpty(_LogFile))
        {
            return;
        }

        if (System.IO.File.Exists(Server.MapPath(SystemLogPath + _LogFile)))
        {
            LogFileMsg = _LogFile;
            XmlDataSource xds = new XmlDataSource();
            xds.DataFile = Server.MapPath(SystemLogPath + _LogFile);

            rptList.DataSource = xds;
            rptList.DataBind();
        }
        else
        {
            LogFileMsg = "日志文件不存在";
            rptList.DataSource = null;
            rptList.DataBind();
        }
    }

    private void rptLogFileList_DataBind()
    {
        rptLogFileList.DataSource = DTLog;
        rptLogFileList.DataBind();
    }

    protected void rptLogFileList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        string LogFileName = e.CommandArgument.ToString();
        if (string.IsNullOrEmpty(LogFileName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://彻底删除
                if (SnSee.Module.File.FileInfo.DeleteFile(SystemLogPath + LogFileName))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，日志文件删除成功！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        Literal litLogFileName;
        CheckBox chkSelect;
        bool _IsAllOk = true;
        string LogFileName;

        foreach (RepeaterItem row in rptLogFileList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litLogFileName = (Literal)row.FindControl("litLogFileName");
            LogFileName = litLogFileName.Text;//取得文件名称

            if (chkSelect.Checked && !string.IsNullOrEmpty(LogFileName))
            {
                if (!SnSee.Module.File.FileInfo.DeleteFile(SystemLogPath + LogFileName))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选日志文件彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选日志文件彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}
