﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

public partial class Admin_Log_SystemExceptionView : System.Web.UI.Page
{
    private Guid? XnID;
    private string LogFileName;
    protected string DateTime;
    protected string UrlReferrer;
    protected string Url;
    protected string Message;
    private string SystemLogPath = "../SystemLog/";  //系统日志目录

    protected void Page_Load(object sender, EventArgs e)
    {
        XnID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);
        LogFileName = Request.QueryString["LogFileName"];

        if (XnID.HasValue && !string.IsNullOrEmpty(LogFileName))
        {
            GetException(LogFileName, XnID.Value);
        }
    }

    /// <summary>
    /// 取得系统异常信息
    /// </summary>
    /// <param name="LogFileName">异常文件</param>
    /// <param name="ID">ID标识</param>
    private void GetException(string LogFileName, Guid ID)
    {
        LogFileName = Server.MapPath(SystemLogPath + LogFileName);

        XmlDocument xd = SnSee.Tool.XmlTool.GetXmlDocument(LogFileName);
        if (xd != null)
        {
            XmlNode xn = null;
            string xnID = null;
            XmlNodeList xnlAll = xd.ChildNodes[1].ChildNodes;
            if (xnlAll != null && xnlAll.Count > 0)
            {
                for (int i = 0; i < xnlAll.Count; i++)
                {
                    xn = xnlAll[i];
                    if (xn != null && xn.Attributes["ID"] != null)
                    {
                        xnID = xn.Attributes["ID"].InnerText;
                        if (xnID.ToLower() == ID.ToString().ToLower())
                        {
                            if (xn.Attributes["DateTime"] != null)
                            {
                                DateTime = xn.Attributes["DateTime"].InnerText;
                            }
                            if (xn.Attributes["UrlReferrer"] != null)
                            {
                                UrlReferrer = xn.Attributes["UrlReferrer"].InnerText;
                            }
                            if (xn.Attributes["Url"] != null)
                            {
                                Url = xn.Attributes["Url"].InnerText;
                            }
                            if (xn.Attributes["Exception"] != null)
                            {
                                Message = xn.Attributes["Exception"].InnerText;
                            }
                        }
                    }
                }
            }
        }
    }
}
