﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;
using SnSee.Config;

public partial class Admin_Login : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void ibtnLogin_Click(object sender, ImageClickEventArgs e)
    {
        string AdminName = txtAdminName.Text;
        string AdminPwd = txtAdminPwd.Text;

        if (Session["CheckCode"] == null || Session["CheckCode"].ToString().ToLower() != txtCheckCode.Text.ToLower())
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "验证码输入错误，请重新输入！");
            return;
        }

        if (string.IsNullOrEmpty(AdminName) || string.IsNullOrEmpty(AdminPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "请输入管理用户名及密码！");
            return;
        }

        if (SnSee.Module.Admin.Admin.AdminLogin(AdminName, AdminPwd))
        {
            Response.Redirect("Default.aspx");
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "用户名或密码错误！");
        }
    }

    protected void ibtnCancel_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect(SnSee.Config.WebConfig.WebPath);
    }
}