﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SnSee.Bean;

public partial class Admin_Main : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    protected string AdminName;
    private string Version;
    protected int ManageTime;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (_AdminBeanLogin != null)
        {
            AdminName = _AdminBeanLogin.AdminName;
        }
        GetConfig();
    }

    /// <summary>
    /// 测试对象能否建立
    /// </summary>
    /// <param name="_obj">对象名</param>
    /// <returns></returns>
    protected bool IsObjInstalled(string _obj)
    {
        bool IsFSOInstalled = false;
        try
        {
            Server.CreateObject(_obj);
            IsFSOInstalled = true;
        }
        catch
        {
            IsFSOInstalled = false;
        }
        return IsFSOInstalled;
    }

    /// <summary>
    /// 取得系统配置
    /// </summary>
    private void GetConfig()
    {
        //是否显示系统公告
        if (SnSee.Config.WebConfig.ViewSystemBulletin)
        {
            pnlSystemBulletin.Visible = true;
            litSystemBulletin.Text = "<iframe width='100%' src='http://www.snsee.com/snsee/SystemBulletin.aspx' marginwidth='0' marginheight='0' frameborder='0' scrolling='no' height='16'></iframe>";
        }

        Version = SnSee.Module.Systems.Version.GetSystemVersion();
        litVersion2.Text = Version;

        //是否显示系统版本升级信息
        if (SnSee.Config.WebConfig.ViewSystemVersionUpdate && SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            pnlSystemVersion.Visible = true;
            CheckSystemVersion();
        }
        else
        {
            pnlSystemVersion.Visible = false;
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;

        if (SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            ManageTime = SnSee.Config.ManageConfig.SystemLoginTime;
        }
        else
        {
            ManageTime = SnSee.Config.ManageConfig.AdminLoginTime;
        }
    }

    private void CheckSystemVersion()
    {
        bool IsNowVersioExists; string NewVersioUrl;
        string NewVersion = SnSee.Module.Systems.Version.GetSystemVersionNew(out IsNowVersioExists, out NewVersioUrl);
        litVersion.Text = Version;
        litNewVersion.Text = NewVersion;

        if (IsNowVersioExists)
        {
            if (System.String.CompareOrdinal(NewVersion, Version) > 0)
            {
                lblResult.Text = "您目前的系统不是最新版本，如需升级，请点击“立即在线升级”按钮！";
                lbtnUpdate.Visible = true;
            }
            else
            {
                lbtnUpdateCheck.Visible = true;
                lblResult.Text = "恭喜您，您当前的系统为最新版本！";
            }
        }
        else
        {
            lbtnUpdateCheck.Visible = true;
            lblResult.Text = "<br />您当前的系统版本号存在异常，但不影响使用，请核查！<br />出错原因：<br />1. 无法获取系统最新版本号；<br />2. 在系统管理目录下的“Version.config”文件中记载着系统版本号，您如果对该文件做过修改，请还原其修改前数据！<br />";
        }
    }

    /// <summary>
    /// 跳转至在线升级页面
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnUpdate_Click(object sender, EventArgs e)
    {
        Response.Redirect("SystemConfig/Version.aspx");
    }

    /// <summary>
    /// 检查升级
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnUpdateCheck_Click(object sender, EventArgs e)
    {
        CheckSystemVersion();
    }
}