﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Order_OrderDetail : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? OrderBaseID;
    protected int? OrderSn;
    protected DateTime? CreateTime;
    protected string UserName;
    protected string OrderState;
    private bool IsEdit;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Order))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0304", true);
        IsEdit = SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0303", false);

        OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["OrderBaseID"]);
        if (OrderBaseID.HasValue)
        {
            if (IsEdit)
            {
                pnlEdit.Visible = true;
                pnlView.Visible = false;
            }

            GetProductModuleConfig();
            if (!IsPostBack)
            {
                GetOrder(OrderBaseID.Value);
                rblState_DataBind(0, "State=1", "Order By SortOrder Asc");  //绑定状态分类列表
                if (IsEdit)
                {
                    rptList_DataBind(rptList, 0, "OrderBaseID='{" + OrderBaseID.Value + "}'", "Order By CreateTime Desc");
                }
                else
                {
                    rptList_DataBind(rptListView, 0, "OrderBaseID='{" + OrderBaseID.Value + "}'", "Order By CreateTime Desc");
                }
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得订单数据
    /// </summary>
    /// <param name="OrderBaseID">订单ID</param>
    private void GetOrder(Guid OrderBaseID)
    {
        OrderBaseBean _OrderBaseBean = (OrderBaseBean)SnSee.Factory.Factory.OrderBase.Select(OrderBaseID);
        if (_OrderBaseBean != null)
        {
            OrderSn = _OrderBaseBean.OrderSn;
            CreateTime = _OrderBaseBean.CreateTime;
            litCountry.Text = txtCountry.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Country);
            litProvince.Text = txtProvince.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Province);
            litCity.Text = txtCity.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.City);
            litAddress.Text = txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Address);
            litContactPerson.Text = txtContactPerson.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.ContactPerson);
            litPhone.Text = txtPhone.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Phone);
            litFax.Text = txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Fax);
            litEmail.Text = txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Email);
            litCompany.Text = txtCompany.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Company);
            litPostalCode.Text = txtPostalCode.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.PostalCode);
            litMessage.Text = txtMessage.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderBaseBean.Message);

            if (_OrderBaseBean.OrderStateClassID.HasValue)
            {
                OrderStateClassBean _OrderStateClassBean = (OrderStateClassBean)SnSee.Factory.Factory.OrderStateClass.Select(_OrderBaseBean.OrderStateClassID.Value);
                if (_OrderStateClassBean != null)
                {
                    OrderState = _OrderStateClassBean.ClassName;
                }
            }

            if (_OrderBaseBean.UserBaseID.HasValue)
            {
                UserBaseBean _UserBaseBean = (UserBaseBean)SnSee.Factory.Factory.UserBase.Select(_OrderBaseBean.UserBaseID.Value);
                if (_UserBaseBean != null)
                {
                    UserName = _UserBaseBean.UserName;
                }
            }
        }
    }

    private void rptList_DataBind(Repeater rpt, int _MaxNum, string _Where, string _OrderBy)
    {
        rpt.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(_MaxNum, _Where, _OrderBy);
        rpt.DataBind();
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxProductPriceView.Visible = boxProductPriceView2.Visible = boxProductPrice.Visible = boxProductPrice2.Visible = SnSee.Config.ProductConfig.PriceOpen;    //价格体系是否启用
    }

    /// <summary>
    /// 取得订单状态分类列表
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序</param>
    private void rblState_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        rblState.DataSource = SnSee.Factory.Factory.OrderStateClass.SelectList(_MaxNum, _Where, _OrderBy);
        rblState.DataBind();
    }

    /// <summary>
    /// 保存订单订购人数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0303", true);
        if (!OrderBaseID.HasValue)
        {
            return;
        }

        OrderBaseBean _OrderBaseBean = new OrderBaseBean();
        _OrderBaseBean.Country = txtCountry.Text;
        _OrderBaseBean.Province = txtProvince.Text;
        _OrderBaseBean.City = txtCity.Text;
        _OrderBaseBean.Address = txtAddress.Text;
        _OrderBaseBean.ContactPerson = txtContactPerson.Text;
        _OrderBaseBean.Phone = txtPhone.Text;
        _OrderBaseBean.Fax = txtFax.Text;
        _OrderBaseBean.Email = txtEmail.Text;
        _OrderBaseBean.Company = txtCompany.Text;
        _OrderBaseBean.PostalCode = txtPostalCode.Text;
        _OrderBaseBean.Message = txtMessage.Text;

        if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，订单订购人信息修改成功！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 保存产品信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnProductOk_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0303", true);
        if (!OrderBaseID.HasValue || rptList.Items.Count <= 0)
        {
            return;
        }

        TextBox txtProductQuantity, txtProductPrice;
        Literal litID;
        OrderProductBean _OrderProductBeanUp = new OrderProductBean();
        OrderProductBean _OrderProductBeanClone = null;
        Guid? OrderProductID;
        int? ProductQuantity;
        decimal? ProductPrice;
        bool IsOk = true;

        for (int i = 0; i < rptList.Items.Count; i++)
        {
            txtProductQuantity = (TextBox)rptList.Items[i].FindControl("txtProductQuantity");
            txtProductPrice = (TextBox)rptList.Items[i].FindControl("txtProductPrice");
            litID = (Literal)rptList.Items[i].FindControl("litID");
            OrderProductID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);

            if (OrderProductID.HasValue)
            {
                _OrderProductBeanClone = (OrderProductBean)_OrderProductBeanUp.Clone();

                ProductQuantity = SnSee.Tool.ConvertTool.GetInt32(txtProductQuantity.Text);
                ProductPrice = SnSee.Tool.ConvertTool.GetDecimal(txtProductPrice.Text);

                if (!ProductQuantity.HasValue)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品数量只能输入数字，请检查后重试！");
                    break;
                }
                if (!ProductPrice.HasValue)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品价格只能输入数字，请检查后重试！");
                    break;
                }

                if (ProductQuantity.HasValue)
                {
                    _OrderProductBeanClone.ProductQuantity = SnSee.Tool.ConvertTool.GetInt32(txtProductQuantity.Text);
                }
                if (ProductPrice.HasValue)
                {
                    _OrderProductBeanClone.ProductPrice = SnSee.Tool.ConvertTool.GetDecimal(txtProductPrice.Text);
                }
                if (!SnSee.Factory.Factory.OrderProduct.Update(_OrderProductBeanClone, OrderProductID.Value))
                {
                    IsOk = false;
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "订单产品信息保存过程中出现错误，请检查后重试！");
                    break;
                }
            }
        }

        if (IsOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品信息保存成功！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 保存订单状态
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnState_Click(object sender, EventArgs e)
    {
        if (!OrderBaseID.HasValue)
        {
            return;
        }

        SnSee.Bean.OrderBaseBean _OrderBaseBean = new OrderBaseBean();
        _OrderBaseBean.OrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(rblState.SelectedValue);
        if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，订单状态保存成功！", Request.RawUrl);
        }
    }
}
