﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Order_OrderList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? OrderClassID;
    private Guid? OrderStateClassID;
    private string Where;
    private int? State;
    private string Where1;
    private string Where2;
    private string Keyword;
    private DateTime? StartTime;
    private DateTime? EndTime;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Order))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0305", true);
        OrderClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["CID"]);
        OrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["OrderStateClassID"]);
        Keyword = Request.QueryString["Keyword"];
        StartTime = SnSee.Tool.ConvertTool.GetDateTime(Request.QueryString["StartTime"]);
        EndTime = SnSee.Tool.ConvertTool.GetDateTime(Request.QueryString["EndTime"]);
        Where1 = Request.QueryString["Where1"];
        Where2 = Request.QueryString["Where2"];

        if (!State.HasValue)
        {
            State = 0;
        }

        Where = "1=1 ";
        
        //组合条件
        if (!string.IsNullOrEmpty(Where1) && !string.IsNullOrEmpty(Where2))
        {
            if (Where2 != "0" && string.IsNullOrEmpty(Keyword))
            {
                return;
            }

            if (!IsPostBack)
            {
                dropWhere1.SelectedValue = Where1;
                dropWhere2.SelectedValue = Where2;
                dropWhere2.Attributes.Add("style", "display:;");
                txtKeyword.Text = Keyword;
                if (Where2 != "0")
                {
                    txtKeyword.Attributes.Add("style", "display:;");
                }
            }

            switch (Where2)
            {
                case "1"://包含
                    switch (Where1.ToLower())
                    {
                        case "ordersn":
                            Where += " And OrderBase." + Where1 + " Like '%" + Keyword + "%'";
                            break;
                        case "userbaseid":
                            Where += " And UserBase.UserName Like '%" + Keyword + "%'";
                            break;
                        case "productname":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName Like '%" + Keyword + "%')";
                            break;
                        case "productmodel":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductModel Like '%" + Keyword + "%')";
                            break;
                        default:
                            Where += " And OrderBase." + Where1 + " Like '%" + Keyword + "%'";
                            break;
                    }
                    break;
                case "2"://等于
                    switch (Where1.ToLower())
                    {
                        case "ordersn":
                            Where += " And OrderBase." + Where1 + " =" + Keyword + "";
                            break;
                        case "userbaseid":
                            Where += " And UserBase.UserName='" + Keyword + "'";
                            break;
                        case "productname":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName='" + Keyword + "')";
                            break;
                        case "productmodel":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductModel='" + Keyword + "')";
                            break;
                        default:
                            Where += " And OrderBase." + Where1 + "='" + Keyword + "'";
                            break;
                    }
                    break;
                case "3"://不包含
                    switch (Where1.ToLower())
                    {
                        case "ordersn":
                            Where += " And OrderBase." + Where1 + " Not Like '%" + Keyword + "%'";
                            break;
                        case "userbaseid":
                            Where += " And UserBase.UserName Not Like '%" + Keyword + "%'";
                            break;
                        case "productname":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName Not Like '%" + Keyword + "%')";
                            break;
                        case "productmodel":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductModel Not Like '%" + Keyword + "%')";
                            break;
                        default:
                            Where += " And OrderBase." + Where1 + " Not Like '%" + Keyword + "%'";
                            break;
                    }
                    break;
                case "4"://不等于
                    switch (Where1.ToLower())
                    {
                        case "ordersn":
                            Where += " And OrderBase." + Where1 + "<>" + Keyword + "";
                            break;
                        case "userbaseid":
                            Where += " And UserBase.UserName<>'" + Keyword + "'";
                            break;
                        case "productname":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName <> '" + Keyword + "')";
                            break;
                        case "productmodel":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductModel <> '" + Keyword + "')";
                            break;
                        default:
                            Where += " And OrderBase." + Where1 + "<>'" + Keyword + "'";
                            break;
                    }
                    break;
                case "0"://为空
                    switch (Where1.ToLower())
                    {
                        case "ordersn":
                            Where += " And (OrderBase." + Where1 + " Is Null) ";
                            break;
                        case "userbaseid":
                            Where += " And (UserBase.UserName Is Null Or UserBase.UserName='') ";
                            break;
                        case "productname":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName Is Null Or ProductName='')";
                            break;
                        case "productmodel":
                            Where += " And OrderBase.ID In(Select OrderBaseID From SnSee_OrderProduct Where ProductName Is Null Or ProductName='')";
                            break;
                        default:
                            Where += " And (OrderBase." + Where1 + " Is Null Or OrderBase." + Where1 + "='')";
                            break;
                    }
                    break;
            }
        }

        //状态分类条件
        if (OrderStateClassID.HasValue)
        {
            if (!IsPostBack)
            {
                dropStateSearch.SelectedValue = OrderStateClassID.Value.ToString();
            }
            Where += " And OrderBase.[OrderStateClassID]='{" + OrderStateClassID.Value + "}'";
        }
        else
        {
            itemBoxAll.Attributes.Add("class", "item_list_cell_ac");
        }

        //订单时间条件
        if (StartTime.HasValue && EndTime.HasValue)
        {
            if (!IsPostBack)
            {
                txtStartTime.Text = StartTime.Value.ToString("yyyy-MM-dd");
                txtEndTime.Text = EndTime.Value.ToString("yyyy-MM-dd");
            }
            Where += " And datediff('d', OrderBase.CreateTime, '" + StartTime.Value + "')<=0 And datediff('d', OrderBase.CreateTime, '" + EndTime.Value + "')>=0";
        }

        GetProductModuleConfig();
        rptStateList_DataBind(0, "State=1", "Order By SortOrder Asc");  //绑定状态分类列表
        if (!IsPostBack)
        {
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By OrderBase.CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxProductPrice.Visible = boxProductPrice2.Visible = SnSee.Config.ProductConfig.PriceOpen;    //价格体系是否启用
        boxUser.Visible = SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.User);
    }

    /// <summary>
    /// 取得订单状态分类列表
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序</param>
    private void rptStateList_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        List<object> _List = SnSee.Factory.Factory.OrderStateClass.SelectList(_MaxNum, _Where, _OrderBy);

        //状态卡
        rptStateList.DataSource = _List;
        rptStateList.DataBind();

        if (!IsPostBack)
        {
            //用与搜索的状态
            dropStateSearch.DataSource = _List;
            dropStateSearch.DataBind();
            dropStateSearch.Items.Insert(0, new ListItem("全部", ""));

            //用与批量设置订单状态的状态
            dropState.DataSource = _List;
            dropState.DataBind();
        }
    }

    /// <summary>
    /// 卡项状态分类绑定项活动
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>
    protected void rptStateList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            HyperLink hlkState = (HyperLink)e.Item.FindControl("hlkState");
            System.Web.UI.HtmlControls.HtmlGenericControl itemBox = (System.Web.UI.HtmlControls.HtmlGenericControl)e.Item.FindControl("itemBox");

            SnSee.Bean.OrderStateClassBean _OrderStateClassBean = (OrderStateClassBean)e.Item.DataItem;

            if (_OrderStateClassBean == null)
            {
                return;
            }

            if (OrderStateClassID.HasValue && itemBox != null && _OrderStateClassBean.ID.Value.ToString().ToLower() == OrderStateClassID.Value.ToString().ToLower())
            {
                itemBox.Attributes.Add("class", "item_list_cell_ac");
            }

            if (hlkState != null)
            {
                hlkState.NavigateUrl = "OrderList.aspx?OrderStateClassID=" + _OrderStateClassBean.ID;
            }
        }
    }

    /// <summary>
    /// 绑定订单列表
    /// </summary>
    /// <param name="_PageIndex"></param>
    /// <param name="_PageSize"></param>
    /// <param name="_Where"></param>
    /// <param name="_OrderBy"></param>
    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.OrderBase.GetOrderListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!OrderBaseID.HasValue || string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        OrderBaseBean _OrderBaseBean = null;
        DropDownList dropState = (DropDownList)e.Item.FindControl("dropState");
        switch (e.CommandName.ToLower())
        {

            case "state_command":
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0304", true);
                if (dropState != null)
                {
                    _OrderBaseBean = new OrderBaseBean();
                    _OrderBaseBean.OrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(dropState.SelectedValue);
                    if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                    }
                }
                SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
            case "delete_command":
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
                _OrderBaseBean = new OrderBaseBean();
                _OrderBaseBean.State = -1;
                if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                }
                SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater rptProductList = (Repeater)e.Item.FindControl("rptProductList");
            Literal litState = (Literal)e.Item.FindControl("litState");
            DropDownList dropState = (DropDownList)e.Item.FindControl("dropState");

            DataRowView dr = (DataRowView)e.Item.DataItem;
            if (dr != null)
            {
                Guid? OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(dr["ID"]);
                if (rptProductList != null && OrderBaseID.HasValue)
                {
                    rptProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + OrderBaseID.Value + "}'", "");
                    rptProductList.DataBind();
                }

                if (dropState != null)
                {
                    dropState.DataSource = SnSee.Factory.Factory.OrderStateClass.SelectList(0, "State=1", "Order By SortOrder Asc");
                    dropState.DataBind();
                }

                Guid? _NowOrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(dr["OrderStateClassID"]);
                if (_NowOrderStateClassID.HasValue)
                {
                    SnSee.Bean.OrderStateClassBean _OrderStateClassBean = (SnSee.Bean.OrderStateClassBean)SnSee.Factory.Factory.OrderStateClass.Select(_NowOrderStateClassID.Value);
                    if (_OrderStateClassBean != null && litState != null)
                    {
                        litState.Text = _OrderStateClassBean.ClassName;
                    }
                    dropState.SelectedValue = _NowOrderStateClassID.Value.ToString();
                }
            }
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("OrderList.aspx?Where1=" + dropWhere1.SelectedValue + "&Where2=" + dropWhere2.SelectedValue + "&Keyword=" + txtKeyword.Text + "&OrderStateClassID=" + dropStateSearch.SelectedValue + "&StartTime=" + txtStartTime.Text + "&EndTime=" + txtEndTime.Text);
    }

    /// <summary>
    /// 批量放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _OrderBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _OrderBaseID.HasValue)
            {
                OrderBaseBean _OrderBaseBean = new OrderBaseBean();
                _OrderBaseBean.State = -1;
                if (!SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, _OrderBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选订单放入回收站成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选订单放入回收站存在失败，请核查后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 批量设置状态
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllState_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0303", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _OrderBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _OrderBaseID.HasValue)
            {
                OrderBaseBean _OrderBaseBean = new OrderBaseBean();
                _OrderBaseBean.OrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(dropState.SelectedValue);
                if (!SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, _OrderBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选订单处理成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选订单处理存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}