﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="OrderRecycleList.aspx.cs"
    Inherits="Admin_Order_OrderRecycleList" EnableViewState="true" %>

<%@ Register Src="../Controls/EditionItem.ascx" TagName="EditionItem" TagPrefix="uc2" %>
<%@ Register Assembly="SnSee.Control" Namespace="SnSee.Control" TagPrefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link href="../Stylesheet/Main.css" rel="stylesheet" type="text/css" />

    <script src="../Javascript/Common.js" type="text/javascript" language="JavaScript"></script>

</head>
<body>
    <form id="form1" runat="server">
        <ul class="tool">
            <li>
                <div class="tool_back">
                    <a href="javaScript:history.back(-1)">返回上一步</a></div>
            </li>
        </ul>
        <div class="main_body">
            <h1>
                <asp:Literal ID="litTitle" runat="server"></asp:Literal>订单回收站管理</h1>
            <div class="ht2">
            </div>
            <div class="divbox">
                <div class="padding8px">
                    <asp:Panel ID="pnlSearch" runat="server" DefaultButton="lbtnSearch">
                        <b>搜索：</b>订单号：<asp:TextBox ID="txtOrderSn" runat="server" Width="100px"></asp:TextBox>
                        用户名：<asp:TextBox ID="txtUserName" runat="server" Width="160px"></asp:TextBox>
                        <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn_bg" OnClick="lbtnSearch_Click">搜索订单</asp:LinkButton></asp:Panel>
                </div>
            </div>
            <div class="ht2">
            </div>
            <div class="divbox2">
                <table width="100%" border="0" cellpadding="0" cellspacing="0" class="tbbox">
                    <tr>
                        <th width="3%" class="input_no">
                            <input id="Checkbox1" type="checkbox" onclick="UnSelectCheckBox(this,'chkSelect')" />
                        </th>
                        <th width="8%">
                            订单号
                        </th>
                        <th width="12%">
                            日期
                        </th>
                        <th width="15%">
                            订购用户
                        </th>
                        <th style="padding: 0px;">
                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                <tr>
                                    <td colspan="5" align="center">
                                        订购产品
                                    </td>
                                </tr>
                                <tr>
                                    <td width="30%" align="center">
                                        产品名称
                                    </td>
                                    <td width="22%" align="center">
                                        型号
                                    </td>
                                    <td width="14%" align="center">
                                        数量
                                    </td>
                                    <td width="16%" align="center" runat="server" id="boxProductPrice">
                                        单价
                                    </td>
                                    <td width="18%" align="center" runat="server" id="boxProductPrice2">
                                        小计
                                    </td>
                                </tr>
                            </table>
                        </th>
                        <th width="10%">
                            操作
                        </th>
                    </tr>
                    <asp:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand" OnItemDataBound="rptList_ItemDataBound">
                        <ItemTemplate>
                            <tr>
                                <td align="center" class="input_no">
                                    <asp:Literal ID="litID" runat="server" Text='<%#Eval("ID")%>' Visible="false"></asp:Literal>
                                    <asp:CheckBox ID="chkSelect" runat="server" />
                                </td>
                                <td align="center">
                                    <%#Eval("OrderSn")%>
                                </td>
                                <td align="center">
                                    <%#Eval("CreateTime","{0:yyyy-MM-dd}")%>
                                </td>
                                <td align="left">
                                    <a href="../User/UserDetail.aspx?ID=<%#Eval("UserBaseID")%>">
                                        <%#Eval("UserName") == DBNull.Value ? "未注册用户" : Eval("UserName")%>
                                    </a>
                                </td>
                                <td align="left" style="padding: 0px;">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="tbbox3">
                                        <asp:Repeater ID="rptProductList" runat="server">
                                            <ItemTemplate>
                                                <tr>
                                                    <td width="30%" align="left" style="text-align: left; padding-left: 2px;">
                                                        <%#Eval("ProductName") %>
                                                    </td>
                                                    <td width="22%" align="left" style="text-align: left; padding-left: 2px;">
                                                        <%#Eval("ProductModel") %>
                                                    </td>
                                                    <td width="14%" align="center">
                                                        <%#Eval("ProductQuantity")%>
                                                    </td>
                                                    <td width="16%" align="center" runat="server" id="boxProductPrice" visible="<%#SnSee.Config.ProductConfig.PriceOpen %>">
                                                        <%#Eval("ProductPrice", "{0:F2}")%>
                                                    </td>
                                                    <td width="18%" align="center" runat="server" id="boxProductPrice2" visible="<%#SnSee.Config.ProductConfig.PriceOpen %>">
                                                        <%#Eval("ProductPrice") != DBNull.Value && Eval("ProductQuantity") != DBNull.Value ? (Convert.ToDecimal(Eval("ProductPrice")) * Convert.ToInt32(Eval("ProductQuantity"))).ToString("F2") : "0"%>
                                                    </td>
                                                </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </table>
                                </td>
                                <td align="center">
                                    <a href="OrderDetail.aspx?OrderBaseID=<%#Eval("ID")%>" title="详情">
                                        <img src="../images/icon_bj.gif" border="0" align="absmiddle" /></a>
                                        <asp:LinkButton ID="lbtnCancelDel" runat="server" ToolTip="还原当前订单"
                                    CommandArgument='<%#Eval("ID")%>' CommandName="CancelDelete_Command"
                                    OnClientClick="return confirm('确认还原当前订单吗？')"><img src="../images/icon_hy.gif" border="0" align="absmiddle" /></asp:LinkButton>
                                    <asp:LinkButton ID="lbtnDel" runat="server" ToolTip="将当前订单彻底删除" CommandArgument='<%#Eval("ID")%>'
                                        CommandName="Delete_Command" OnClientClick="return confirm('确认将当前订单彻底删除？')"><img src="../images/icon_sc.gif" border="0" align="absmiddle" /></asp:LinkButton>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </div>
            <div class="ht2">
            </div>
            <div class="padding4px">
                <input type="button" id="Button7" value="全选" onclick="SelectCheckBox(this, 'chkSelect',1)"
                    class="btn_bg2" />
                <input type="button" id="Button8" value="反选" onclick="UnSelectCheckBox(this,'chkSelect')"
                    class="btn_bg2" />
                <input type="button" id="Button9" value="取消选择" onclick="SelectCheckBox(this, 'chkSelect',2)"
                    class="btn_bg2" />
                |
                <asp:Button ID="btnAllCancelDelete" runat="server" Text="还原" CssClass="btn_bg2" OnClientClick="return confirm('确认将当前选中订单还原删除？')" ToolTip="将当前选中订单还原删除" OnClick="btnAllCancelDelete_Click" />
                <asp:Button ID="btnAllDel" runat="server" Text="彻底删除" CssClass="btn_bg2" OnClick="btnAllDel_Click"
                    OnClientClick="return confirm('确认将当前选中订单彻底删除？')" ToolTip="将当前选中订单彻底删除" />
            </div>
            <div class="webpage">
                <cc1:WebPage ID="WebPage1" runat="server" PageSize="20">
                </cc1:WebPage>
            </div>
            <div class="ht">
            </div>
            <div class="ht">
            </div>
            <ul class="ac_intro" runat="server" id="boxPageExplain">
                <li class="ac_intro_title">说明：</li>
                <li class="ac_intro_item">1. 订单的回收站管理。</li>
            </ul>
        </div>
    </form>
</body>
</html>
