﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using SnSee.Bean;

public partial class Admin_Order_OrderRecycleList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? OrderClassID;
    private string UserName;
    private string OrderSn = null;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Order))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0305", true);
        OrderClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["CID"]);
        UserName = Request.QueryString["UserName"];

        Where = "1=1 And OrderBase.[State]=-1";
        if (!string.IsNullOrEmpty(OrderSn))
        {
            Where += " And OrderBase.[OrderSn] Like '%" + OrderSn + "%'";
        }
        if (!string.IsNullOrEmpty(UserName))
        {
            UserName = SnSee.Tool.EncodeTool.HtmlEncode(UserName);
            Where += " And UserBase.[UserName] Like '%" + UserName + "%'";
        }

        GetProductModuleConfig();
        if (!IsPostBack)
        {
            txtUserName.Text = UserName;
            txtOrderSn.Text = OrderSn;
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By OrderBase.CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxProductPrice.Visible = boxProductPrice2.Visible = SnSee.Config.ProductConfig.PriceOpen;    //价格体系是否启用
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.OrderBase.GetOrderListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!OrderBaseID.HasValue || string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        OrderBaseBean _OrderBaseBean = null;
        DropDownList dropState = (DropDownList)e.Item.FindControl("dropState");
        switch (e.CommandName.ToLower())
        {
            case "canceldelete_command"://还原删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
                _OrderBaseBean = new OrderBaseBean();
                _OrderBaseBean.State = 0;
                if (SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, OrderBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                }
                SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
            case "delete_command"://彻底删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
                //删除订单中的产品/订单
                if (SnSee.Factory.Factory.OrderProduct.Delete("OrderBaseID='{" + OrderBaseID.Value + "}'"))
                {
                    if (SnSee.Factory.Factory.OrderBase.Delete(OrderBaseID.Value))
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                    }
                }
                SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater rptProductList = (Repeater)e.Item.FindControl("rptProductList");

            DataRowView dr = (DataRowView)e.Item.DataItem;
            if (dr != null)
            {
                Guid? OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(dr["ID"]);
                if (rptProductList != null && OrderBaseID.HasValue)
                {
                    rptProductList.DataSource = SnSee.Factory.Factory.OrderProduct.SelectList(0, "OrderBaseID='{" + OrderBaseID.Value + "}'", "");
                    rptProductList.DataBind();
                }
            }
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("OrderList.aspx?UserName=" + txtUserName.Text + "&OrderSn=" + txtOrderSn.Text);
    }

    /// <summary>
    /// 批量彻底删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _OrderBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _OrderBaseID.HasValue)
            {
                //删除订单中的产品/订单
                if (SnSee.Factory.Factory.OrderProduct.Delete("OrderBaseID='{" + _OrderBaseID.Value + "}'"))
                {
                    if (!SnSee.Factory.Factory.OrderBase.Delete(_OrderBaseID.Value))
                    {
                        _IsAllOk = false;
                    }
                }
                else
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选订单彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选订单彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 批量还原
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllCancelDelete_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0302", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _OrderBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _OrderBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _OrderBaseID.HasValue)
            {
                OrderBaseBean _OrderBaseBean = new OrderBaseBean();
                _OrderBaseBean.State = 0;
                if (!SnSee.Factory.Factory.OrderBase.Update(_OrderBaseBean, _OrderBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选订单还原成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选订单还原存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}
