﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Order_OrderStateClassSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? OrderStateClassID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Order))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        ActionType = Request["AC"];

        OrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!IsPostBack)
        {
            if (OrderStateClassID.HasValue)
            {
                SetOrderStateClassData(OrderStateClassID.Value);
            }
            rptList_DataBind();
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入指定ID的数据
    /// </summary>
    /// <param name="ID">分类ID</param>
    private void SetOrderStateClassData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        OrderStateClassBean _OrderStateClassBean = (OrderStateClassBean)SnSee.Factory.Factory.OrderStateClass.Select(ID);
        if (_OrderStateClassBean != null)
        {
            txtClassName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderStateClassBean.ClassName);
            txtClassKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_OrderStateClassBean.ClassKey);
            dropState.SelectedValue = _OrderStateClassBean.State.Value.ToString();
            txtSortOrder.Text = _OrderStateClassBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.OrderStateClass.SelectList(0, "", "Order By SortOrder Asc, CreateTime Desc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcOrderStateClassID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcOrderStateClassID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                SnSee.Bean.OrderBaseBean _OrderBaseBeanCheck = (SnSee.Bean.OrderBaseBean)Factory.OrderBase.Select("OrderStateClassID='{" + AcOrderStateClassID.Value + "}'");
                if (_OrderBaseBeanCheck != null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "已经有订单存在当前状态，不能直接删除，请移除有当前状态的订单数据，再进行删除操作！", Request.Url.ToString());
                    return;
                }

                if (SnSee.Factory.Factory.OrderStateClass.Delete(AcOrderStateClassID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string ClassName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassName.Text);
        string ClassKey = SnSee.Tool.EncodeTool.HtmlEncode(txtClassKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "ClassKey='" + ClassKey + "'";
        if (OrderStateClassID.HasValue)
        {
            Where += " And ClassKey<>'" + ClassKey + "'";
        }
        OrderStateClassBean _OrderStateClassBeanCheck = (OrderStateClassBean)SnSee.Factory.Factory.OrderStateClass.Select(Where);
        if (_OrderStateClassBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的标识，请更换另一个后重试操作！");
            return;
        }

        OrderStateClassBean _OrderStateClassBean = new OrderStateClassBean();
        _OrderStateClassBean.ClassName = ClassName;
        _OrderStateClassBean.ClassKey = ClassKey;
        _OrderStateClassBean.State = State;
        _OrderStateClassBean.SortOrder = SortOrder;

        bool _Return = false;
        if (OrderStateClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            _Return = SnSee.Factory.Factory.OrderStateClass.Update(_OrderStateClassBean, OrderStateClassID.Value);
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);
            _Return = SnSee.Factory.Factory.OrderStateClass.Insert(_OrderStateClassBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}
