﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Product_Product : System.Web.UI.Page
{
    protected Guid? ProductBaseID;
    protected Guid? EditionID;
    AdminBaseBean _AdminBeanLogin = null;
    protected Guid? ProductClassParentID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0104", true);
        ProductClassParentID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductClassParentID"]);
        ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        if (ProductClassParentID.HasValue)
        {
            GetProductClassParent(ProductClassParentID.Value);
        }
        if (!IsPostBack)
        {
            GetProductModuleConfig();
            if (ProductBaseID.HasValue)
            {
                boxDel.Visible = true;
                LoadProductBase(ProductBaseID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxProductOtherPic.Visible = SnSee.Config.ProductConfig.OtherPicOpen;
        chkIsMakeProductPicPath1.Visible = pnlPicPath1.Visible = SnSee.Config.ProductConfig.ProductPicPath1Open;
        chkIsMakeProductPicPath2.Visible = pnlPicPath2.Visible = SnSee.Config.ProductConfig.ProductPicPath2Open;
        chkIsMakeProductPicPath3.Visible = pnlPicPath3.Visible = SnSee.Config.ProductConfig.ProductPicPath3Open;

        if (SnSee.Config.ProductConfig.MakeProductPicPath1Open && SnSee.Config.ProductConfig.ProductPicPath1Open)
        {
            chkIsMakeProductPicPath1.Checked = true;
        }
        else
        {
            chkIsMakeProductPicPath1.Visible = false;
        }
        if (SnSee.Config.ProductConfig.MakeProductPicPath2Open && SnSee.Config.ProductConfig.ProductPicPath2Open)
        {
            chkIsMakeProductPicPath2.Checked = true;
            pnlPicPath2.Attributes.Add("style", "display:none;");
        }
        else
        {
            chkIsMakeProductPicPath2.Visible = false;
        }
        if (SnSee.Config.ProductConfig.MakeProductPicPath3Open && SnSee.Config.ProductConfig.ProductPicPath3Open)
        {
            chkIsMakeProductPicPath3.Checked = true;
            pnlPicPath3.Attributes.Add("style", "display:none;");
        }
        else
        {
            chkIsMakeProductPicPath3.Visible = false;
        }

        chkIsMakeProductPicPath1.Checked = SnSee.Config.ProductConfig.MakeProductPicPath1Open;

        chkIsMakeProductPicPath1.Text = "自动生成大图(" + SnSee.Config.ProductConfig.ProductPicPath1Width + "×" + SnSee.Config.ProductConfig.ProductPicPath1Height + ")";
        chkIsMakeProductPicPath2.Text = "自动生成中图(" + SnSee.Config.ProductConfig.ProductPicPath2Width + "×" + SnSee.Config.ProductConfig.ProductPicPath2Height + ")";
        chkIsMakeProductPicPath3.Text = "自动生成小图(" + SnSee.Config.ProductConfig.ProductPicPath3Width + "×" + SnSee.Config.ProductConfig.ProductPicPath3Height + ")";

        litMustProductPicPath1.Visible = SnSee.Config.ProductConfig.MustProductPicPath1;
        litMustProductPicPath2.Visible = SnSee.Config.ProductConfig.MustProductPicPath2;
        litMustProductPicPath3.Visible = SnSee.Config.ProductConfig.MustProductPicPath3;
    }

    /// <summary>
    /// 取得产品分类父级数据
    /// </summary>
    /// <param name="ID">父级分类ID</param>
    private void GetProductClassParent(Guid ID)
    {
        SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ID);
        if (_ProductClassBean != null)
        {
            litTitle.Text = _ProductClassBean.ClassName + "管理 -> " + litTitle.Text;
        }
    }

    /// <summary>
    /// 载入内容
    /// </summary>
    /// <param name="EditionID">版本ID</param>
    /// <param name="ProductID">产品ID</param>
    private void LoadProductBase(Guid ProductBaseID)
    {
        ProductBaseBean _ProductBaseBean = (ProductBaseBean)SnSee.Factory.Factory.ProductBase.Select(ProductBaseID);
        if (_ProductBaseBean != null)
        {
            if (!string.IsNullOrEmpty(_ProductBaseBean.PicPath1))
            {
                boxPicPath1.Visible = true;
                imgPicPath1.ImageUrl = _ProductBaseBean.PicPath1;
            }
            if (!string.IsNullOrEmpty(_ProductBaseBean.PicPath2))
            {
                boxPicPath2.Visible = true;
                imgPicPath2.ImageUrl = _ProductBaseBean.PicPath2;
            }
            if (!string.IsNullOrEmpty(_ProductBaseBean.PicPath3))
            {
                boxPicPath3.Visible = true;
                imgPicPath3.ImageUrl = _ProductBaseBean.PicPath3;
            }
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        string FilePath1 = string.Empty, FilePath2 = string.Empty, FilePath3 = string.Empty;
        Guid NowProductID = Guid.NewGuid();
        bool IsFileUp = true;

        ProductBaseBean _ProductBaseBean = new ProductBaseBean();
        #region 文件上传
        //大图
        if (SnSee.Config.ProductConfig.MustProductPicPath1 && (fuPicPath1.PostedFile == null || fuPicPath1.PostedFile.ContentLength <= 0) && !ProductBaseID.HasValue && SnSee.Config.ProductConfig.ProductPicPath1Open)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择大图文件！", Request.RawUrl);
            return;
        }
        //中图
        if (SnSee.Config.ProductConfig.MustProductPicPath2 && (fuPicPath2.PostedFile == null || fuPicPath2.PostedFile.ContentLength <= 0) && !ProductBaseID.HasValue && SnSee.Config.ProductConfig.ProductPicPath2Open && !chkIsMakeProductPicPath2.Checked)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择中图文件！", Request.RawUrl);
            return;
        }
        //小图
        if (SnSee.Config.ProductConfig.MustProductPicPath3 && (fuPicPath3.PostedFile == null || fuPicPath3.PostedFile.ContentLength <= 0) && !ProductBaseID.HasValue && SnSee.Config.ProductConfig.ProductPicPath3Open && !chkIsMakeProductPicPath3.Checked)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择小图文件！", Request.RawUrl);
            return;
        }

        string PicPathFileName = Guid.NewGuid().ToString();  //文件名，公用于大、中、小图
        string PicPathFilePath = SnSee.Config.WebConfig.UploadFilePath + "/" + SnSee.Module.File.FileInfo.GetFilePath();//文件目录路径，公用于大、中、小图
        FilePath1 = PicPathFilePath + "/" + PicPathFileName + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //大图文件全部路径
        FilePath2 = PicPathFilePath + "/" + PicPathFileName + "_m" + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //中图文件全部路径
        FilePath3 = PicPathFilePath + "/" + PicPathFileName + "_s" + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //小图文件全部路径

        PicPathFilePath = PicPathFilePath.Replace("//", "/");
        FilePath1 = FilePath1.Replace("//", "/");
        FilePath2 = FilePath2.Replace("//", "/");
        FilePath3 = FilePath3.Replace("//", "/");

        //上传大图
        if (fuPicPath1.PostedFile != null && fuPicPath1.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath1Open)
        {
            FileUploadBean _FileUploadBean = new FileUploadBean();
            if (chkIsMakeProductPicPath1.Checked)
            {//根据选择的大图片自动生成大图 
                _FileUploadBean.IsDispose = true;
                _FileUploadBean.Width = SnSee.Config.ProductConfig.ProductPicPath1Width;
                _FileUploadBean.Height = SnSee.Config.ProductConfig.ProductPicPath1Height;
            }
            if (chkIsMakeProductPicPath2.Checked && SnSee.Config.ProductConfig.ProductPicPath2Open)
            {//根据选择的大图片自动生成中图
                FileUploadBean _FileUploadBean2 = new FileUploadBean();
                _FileUploadBean2.IsDispose = true;
                _FileUploadBean2.Width = SnSee.Config.ProductConfig.ProductPicPath2Width;
                _FileUploadBean2.Height = SnSee.Config.ProductConfig.ProductPicPath2Height;

                if (!SnSee.Module.File.FileInfo.Upload(_FileUploadBean2, fuPicPath1.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_m", System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName), true, fuPicPath1.PostedFile.ContentType))
                {
                    IsFileUp = false;
                }
            }
            if (chkIsMakeProductPicPath3.Checked && SnSee.Config.ProductConfig.ProductPicPath3Open)
            {//根据选择的大图片自动生成小图
                _FileUploadBean.IsMiniature = true;
                _FileUploadBean.MiniWidth = SnSee.Config.ProductConfig.ProductPicPath3Width;
                _FileUploadBean.MiniHeight = SnSee.Config.ProductConfig.ProductPicPath3Height;
            }

            if (!SnSee.Module.File.FileInfo.Upload(_FileUploadBean, fuPicPath1.PostedFile.InputStream, PicPathFilePath, PicPathFileName, System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName), true, fuPicPath1.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        //上传中图，当有选择中图文件+中图已经启用+不自动生成中图
        if (fuPicPath2.PostedFile != null && fuPicPath2.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath2Open && !chkIsMakeProductPicPath2.Checked)
        {
            if (!SnSee.Module.File.FileInfo.Upload(null, fuPicPath2.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_m", System.IO.Path.GetExtension(fuPicPath2.PostedFile.FileName), true, fuPicPath2.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        //当有选择小图文件+小图已经启用+不自动生成小图
        if (fuPicPath3.PostedFile != null && fuPicPath3.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath3Open && !chkIsMakeProductPicPath3.Checked)
        {//上传小图
            if (!SnSee.Module.File.FileInfo.Upload(null, fuPicPath3.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_s", System.IO.Path.GetExtension(fuPicPath3.PostedFile.FileName), true, fuPicPath3.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        if (!IsFileUp)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片上传失败，请检查后重试！", Request.RawUrl);
            return;
        }
        #endregion

        if (!string.IsNullOrEmpty(FilePath1))
        {
            _ProductBaseBean.PicPath1 = FilePath1;
        }
        if (!string.IsNullOrEmpty(FilePath2))
        {
            _ProductBaseBean.PicPath2 = FilePath2;
        }
        if (!string.IsNullOrEmpty(FilePath3))
        {
            _ProductBaseBean.PicPath3 = FilePath3;
        }

        if (string.IsNullOrEmpty(_ProductBaseBean.PicPath1) && string.IsNullOrEmpty(_ProductBaseBean.PicPath2) && string.IsNullOrEmpty(_ProductBaseBean.PicPath3))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片上传失败或者您还没有选择要上传的图片，请检查后重试！", Request.RawUrl);
            return;
        }

        ProductBaseBean _ProductBaseBeanCheck = null;
        if (ProductBaseID.HasValue)
        {
            _ProductBaseBeanCheck = (ProductBaseBean)SnSee.Factory.Factory.ProductBase.Select(ProductBaseID.Value);
        }

        if (ProductBaseID.HasValue && _ProductBaseBeanCheck != null)
        {//编辑
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            if (SnSee.Factory.Factory.ProductBase.Update(_ProductBaseBean, ProductBaseID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品编辑成功！进入下一步：填写产品不同语言版本资料", "ProductEdition.aspx?ID=" + ProductBaseID.Value.ToString() + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID.Value);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "产品编辑失败，请检查后重试！", Request.RawUrl);
                return;
            }
        }
        else
        {
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);
            ProductBaseID = Guid.NewGuid();
            _ProductBaseBean.ID = ProductBaseID;
            if (SnSee.Factory.Factory.ProductBase.Insert(_ProductBaseBean))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品增加成功！进入下一步：填写产品不同语言版本资料", "ProductEdition.aspx?ID=" + ProductBaseID.Value.ToString() + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID.Value);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "产品增加失败，请检查后重试！", Request.RawUrl);
                return;
            }
        }

    }

    /// <summary>
    /// 当前产品放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        if (ProductBaseID.HasValue)
        {
            ProductListBean _ProductListBean = new ProductListBean();
            _ProductListBean.State = 0;
            if (SnSee.Factory.Factory.ProductList.Update(_ProductListBean, "ProductBaseID='{" + ProductBaseID.Value + "}'"))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "ProductList.aspx?ProductClassParentID=" + ProductClassParentID + "&EID=" + EditionID);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "数据错误，无法进行删除！", Request.RawUrl);
        }
    }
}