﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Product_ProductAttribute : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private Guid? ProductAttributeID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        ActionType = Request["AC"];
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        ProductAttributeID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        EditionItem1.NavName = "ProductAttribute";
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = ProductAttributeID;
        EditionItem1.NavDir = "Product";

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                if (ProductAttributeID.HasValue)
                {
                    SetProductAttributeData(ProductAttributeID.Value);
                }
                rptList_DataBind();
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;

    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
            litTitle3.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入指定ID的产品参数数据
    /// </summary>
    /// <param name="ID">分类ID</param>
    private void SetProductAttributeData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        ProductAttributeBean _ProductAttributeBean = (ProductAttributeBean)SnSee.Factory.Factory.ProductAttribute.Select(ID);
        if (_ProductAttributeBean != null)
        {
            dropAttributeType.SelectedValue = _ProductAttributeBean.AttributeType.Value.ToString();
            txtAttributeName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductAttributeBean.AttributeName);
            txtAttributeKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductAttributeBean.AttributeKey);
            dropState.SelectedValue = _ProductAttributeBean.State.Value.ToString();
            txtSortOrder.Text = _ProductAttributeBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入产品参数列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.ProductAttribute.SelectList(0, "EditionID='{" + EditionID + "}'", "Order By SortOrder Asc, CreateTime Desc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcProductAttributeID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcProductAttributeID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                //删除相关数据
                if (SnSee.Factory.Factory.ProductAttributeList.Delete("ProductAttributeID='{" + AcProductAttributeID.Value + "}'"))
                {
                    if (SnSee.Factory.Factory.ProductAttribute.Delete(AcProductAttributeID.Value))
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                    }
                    else
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                    }
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string AttributeName = SnSee.Tool.EncodeTool.HtmlEncode(txtAttributeName.Text);
        string AttributeKey = SnSee.Tool.EncodeTool.HtmlEncode(txtAttributeKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "AttributeKey='" + AttributeKey + "'";
        if (ProductAttributeID.HasValue)
        {
            Where += " And AttributeKey<>'" + AttributeKey + "'";
        }
        ProductAttributeBean _ProductAttributeBeanCheck = (ProductAttributeBean)SnSee.Factory.Factory.ProductAttribute.Select(Where);
        if (_ProductAttributeBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的版本标识，请更换另一个后重试操作！");
            return;
        }

        ProductAttributeBean _ProductAttributeBean = new ProductAttributeBean();
        _ProductAttributeBean.AttributeName = AttributeName;
        _ProductAttributeBean.AttributeKey = AttributeKey;
        _ProductAttributeBean.State = State;
        _ProductAttributeBean.SortOrder = SortOrder;
        _ProductAttributeBean.EditionID = EditionID;

        bool _Return = false;
        if (ProductAttributeID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            _Return = SnSee.Factory.Factory.ProductAttribute.Update(_ProductAttributeBean, ProductAttributeID.Value);
        }
        else
        {//增加
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);
            _Return = SnSee.Factory.Factory.ProductAttribute.Insert(_ProductAttributeBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}