﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Product_ProductBaseList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private int EditionMaxNum = 0;
    private string EditionWhere = "";
    private string EditionOrderBy = "Order By SortOrder Asc, CreateTime Asc";
    protected Guid? ProductClassParentID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        ProductClassParentID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductClassParentID"]);
        EditionItem1.NavName = "ProductList";
        EditionItem1.NavDir = "Product";
        EditionItem1.UrlParameter = "&ProductClassParentID=" + ProductClassParentID;

        GetProductModuleConfig();
        if (!IsPostBack)
        {
            rptEditionList_DataBind(EditionMaxNum, EditionWhere, EditionOrderBy);
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, "", "Order By CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxPicPath3.Visible = SnSee.Config.ProductConfig.ProductPicPath3Open;
    }

    /// <summary>
    /// 取得语言版本资料
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序</param>
    private void rptEditionList_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        rptEditionList.DataSource = SnSee.Factory.Factory.Edition.SelectList(_MaxNum, _Where, _OrderBy);
        rptEditionList.DataBind();
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ProductBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater rptEditionList = (Repeater)e.Item.FindControl("rptEditionList");
            if (rptEditionList != null)
            {
                rptEditionList.DataSource = SnSee.Factory.Factory.Edition.SelectList(EditionMaxNum, EditionWhere, EditionOrderBy);
                rptEditionList.DataBind();
            }
        }
    }

    protected void rptEditionList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            HyperLink hlkLink = (HyperLink)e.Item.FindControl("hlkLink");
            Control parentRptList = e.Item.Parent.Parent;

            SnSee.Bean.EditionBean _EditionBean = (SnSee.Bean.EditionBean)e.Item.DataItem;
            if (_EditionBean == null)
            {
                return;
            }

            if (parentRptList != null)
            {
                Guid? ProductBaseID = null;
                Literal litID = (Literal)parentRptList.FindControl("litID");
                if (litID != null)
                {
                    ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);
                    if (ProductBaseID.HasValue)
                    {
                        //检查当前语言版本是否已经增加过产品资料
                        SnSee.Bean.ProductListBean _ProductListBean = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}' And EditionID='{" + _EditionBean.ID.Value + "}'");
                        if (_ProductListBean != null)
                        {//能找到数据，说明已经增加过 
                            hlkLink.ImageUrl = "../images/icon_ok.gif";
                            hlkLink.ToolTip = "已添加当前对应语言版本的产品资料；点击可直接对其编辑";
                            hlkLink.NavigateUrl = "ProductEdition.aspx?ID=" + ProductBaseID.Value + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + _EditionBean.ID;
                        }
                        else
                        {//未增加
                            hlkLink.ImageUrl = "../images/icon_nook.gif";
                            hlkLink.ToolTip = "未添加当前对应语言版本的产品资料；点击可直接对其添加";
                            hlkLink.NavigateUrl = "ProductEdition.aspx?ID=" + ProductBaseID.Value + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + _EditionBean.ID;
                        }
                    }
                }
            }
        }
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!ProductBaseID.HasValue)
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://彻底删除
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                //检查
                SnSee.Bean.ProductListBean _ProductListBeanCheck = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}'");
                if (_ProductListBeanCheck != null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "当前产品基础资料存在语言版本数据，不能直接进行删除，删除前请先彻底删除存在于语言版中的数据！", Request.RawUrl);
                    return;
                }

                SnSee.Bean.ProductBaseBean _ProductBaseBean = (SnSee.Bean.ProductBaseBean)SnSee.Factory.Factory.ProductBase.Select(ProductBaseID.Value);
                if (_ProductBaseBean != null)
                {
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath1);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath2);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath3);
                }

                if (SnSee.Factory.Factory.ProductBase.Delete(ProductBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品基础资料彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品基础资料彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? ProductBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得产品列表ID

            if (chkSelect.Checked && ProductBaseID.HasValue)
            {
                //检查
                SnSee.Bean.ProductListBean _ProductListBeanCheck = (SnSee.Bean.ProductListBean)SnSee.Factory.Factory.ProductList.Select("ProductBaseID='{" + ProductBaseID.Value + "}'");
                if (_ProductListBeanCheck != null)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "当前产品基础资料存在语言版本数据，不能直接进行删除，删除前请先彻底删除存在于语言版中的数据！", Request.RawUrl);
                    return;
                }

                SnSee.Bean.ProductBaseBean _ProductBaseBean = (SnSee.Bean.ProductBaseBean)SnSee.Factory.Factory.ProductBase.Select(ProductBaseID.Value);
                if (_ProductBaseBean != null)
                {
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath1);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath2);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductBaseBean.PicPath3);
                }

                if (!SnSee.Factory.Factory.ProductBase.Delete(ProductBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选产品基础资料彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选产品基础资料彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}
