﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_Product_ProductClass : System.Web.UI.Page
{
    SnSee.Bean.AdminBaseBean _AdminBeanLogin = null;
    protected Guid? ProductClassID;
    protected Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);

        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        ProductClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionItem1.NavName = "ProductClass";
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = ProductClassID;
        EditionItem1.NavDir = "Product";

        if (!IsPostBack)
        {
            if (SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.User))
            {//如果开启用户模块
                boxUserLevelIDList.Visible = true;
                cblUserLevelIDList_DataBind();
            }

            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value);
                if (EditionID.HasValue && ProductClassID.HasValue)
                {//编辑
                    EditionItem1.IsViewCellEditionID = true;
                    GetProductClassData(EditionID.Value, ProductClassID.Value);
                }
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        SnSee.Bean.EditionBean _EditionBean = (SnSee.Bean.EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 取得用户等级
    /// </summary>
    private void cblUserLevelIDList_DataBind()
    {
        cblUserLevelIDList.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "State=1", "Order By SortOrder Asc");
        cblUserLevelIDList.DataBind();
    }

    /// <summary>
    /// 载入指定ID的版本的分类数据
    /// </summary>
    /// <param name="EditiionID">语言版本ID</param>
    /// <param name="ID">分类ID</param>
    private void GetProductClassData(Guid EditionID, Guid ID)
    {
        SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select("EditionID='{" + EditionID + "}' and ID='{" + ID + "}'");
        if (_ProductClassBean != null)
        {
            if (_ProductClassBean.ParentID.HasValue)
            {
                dropClass.SelectedValue = _ProductClassBean.ParentID.Value.ToString();
            }
            txtClassName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductClassBean.ClassName);
            txtClassByName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductClassBean.ClassByname);
            txtClassKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductClassBean.ClassKey);
            if (_ProductClassBean.State.HasValue)
            {
                dropState.SelectedValue = _ProductClassBean.State.Value.ToString();
            }
            if (_ProductClassBean.SortOrder.HasValue)
            {
                txtSortOrder.Text = _ProductClassBean.SortOrder.Value.ToString();
            }
            if (_ProductClassBean.IsChild.HasValue)
            {
                chkIsChild.Checked = _ProductClassBean.IsChild.Value;
            }
            if (_ProductClassBean.IsDefault.HasValue)
            {
                chkIsDefault.Checked = _ProductClassBean.IsDefault.Value;
            }
            if (_ProductClassBean.IsMenuView.HasValue)
            {
                chkIsMenuView.Checked = _ProductClassBean.IsMenuView.Value;
            }
            txtBody.Value = _ProductClassBean.Body;
            if (!string.IsNullOrEmpty(_ProductClassBean.ImageUrl))
            {
                imgImageUrl.Visible = true;
                imgImageUrl.ImageUrl = _ProductClassBean.ImageUrl;
            }
            #region 用户查看等级
            if (!string.IsNullOrEmpty(_ProductClassBean.UserLevelIDList) && cblUserLevelIDList.Items.Count > 0)
            {
                for (int i = 0; i < cblUserLevelIDList.Items.Count; i++)
                {
                    if (cblUserLevelIDList.Items[i] != null && !string.IsNullOrEmpty(cblUserLevelIDList.Items[i].Value) && !string.IsNullOrEmpty(_ProductClassBean.UserLevelIDList) && _ProductClassBean.UserLevelIDList.Contains(cblUserLevelIDList.Items[i].Value))
                    {
                        cblUserLevelIDList.Items[i].Selected = true;
                    }
                }
            }
            #endregion
        }
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        DataTable dt = null;
        if (ProductClassID.HasValue)
        {
            dt = SnSee.Module.Product.ProductClassTree.GetClassTreeList(null, ProductClassID.Value, "EditionID='{" + EditionID + "}' And (IsChild=0 Or IsChild Is Null)", "Order by SortOrder asc");
        }
        else
        {
            dt = SnSee.Module.Product.ProductClassTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}' And (IsChild=0 Or IsChild Is Null)", "Order by SortOrder asc");
        }

        dropClass.DataSource = dt;
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        Guid? ParentID = SnSee.Tool.ConvertTool.GetGuid(dropClass.SelectedValue);
        string ClassName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassName.Text);
        string ClassByName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassByName.Text);
        string ClassKey = SnSee.Tool.EncodeTool.HtmlEncode(txtClassKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);
        bool? IsChild = chkIsChild.Checked;
        bool? IsDefault = chkIsDefault.Checked;
        bool? IsMenuView = chkIsMenuView.Checked;

        if (string.IsNullOrEmpty(ClassName) || string.IsNullOrEmpty(ClassKey))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入语言版本名称或版本标识！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "ClassKey='" + ClassKey + "'";
        if (ProductClassID.HasValue)
        {
            Where += " And ClassKey<>'" + ClassKey + "'";
        }
        SnSee.Bean.ProductClassBean _ProductClassBeanCheck = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(Where);
        if (_ProductClassBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的版本标识，请更换另一个后重试操作！");
            return;
        }

        SnSee.Bean.ProductClassBean _ProductClassBean = new SnSee.Bean.ProductClassBean();
        _ProductClassBean.EditionID = EditionID;
        _ProductClassBean.ClassName = ClassName;
        _ProductClassBean.ClassByname = ClassByName;
        _ProductClassBean.ClassKey = ClassKey;
        _ProductClassBean.State = State;
        _ProductClassBean.IsChild = IsChild;
        _ProductClassBean.IsDefault = IsDefault;
        _ProductClassBean.IsMenuView = IsMenuView;
        _ProductClassBean.SortOrder = SortOrder;
        _ProductClassBean.Depth = 1;
        _ProductClassBean.ParentID = ParentID;
        _ProductClassBean.Body = txtBody.Value;
        #region 用户查看等级
        _ProductClassBean.UserLevelIDList = "";
        if (cblUserLevelIDList.Items.Count > 0)
        {
            for (int i = 0; i < cblUserLevelIDList.Items.Count; i++)
            {
                if (cblUserLevelIDList.Items[i] != null && cblUserLevelIDList.Items[i].Selected)
                {
                    _ProductClassBean.UserLevelIDList += "{" + cblUserLevelIDList.Items[i].Value + "},";
                }
            }
        }
        _ProductClassBean.UserLevelIDList = _ProductClassBean.UserLevelIDList.TrimEnd(new char[] { ',' });
        #endregion
        #region 上传分类图示
        bool IsImageUrl = true;
        bool IsUpImageUrl = false;
        if (fileImageUrl.PostedFile != null && fileImageUrl.PostedFile.ContentLength > 0)
        {
            SnSee.Bean.FileUploadBean _FileUploadBean = null;
            if (chkIsImageMake.Checked)
            {//自动生成小图
                int? MakeImageWidth = SnSee.Tool.ConvertTool.GetInt32(txtMakeImageWidth.Text);
                int? MakeImageHeight = SnSee.Tool.ConvertTool.GetInt32(txtMakeImageHeight.Text);
                if (!MakeImageWidth.HasValue || !MakeImageHeight.HasValue)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "请输入自动生成时的图片尺寸！");
                    return;
                }

                _FileUploadBean = new SnSee.Bean.FileUploadBean();
                _FileUploadBean.Width = MakeImageWidth.Value;
                _FileUploadBean.Height = MakeImageHeight.Value;
                _FileUploadBean.IsDispose = true;
            }

            string FilePath = SnSee.Config.WebConfig.UploadFilePath + "/" + SnSee.Module.File.FileInfo.GetFilePath();//文件目录路径
            string FileName = Guid.NewGuid().ToString();  //文件名
            string FileExName = System.IO.Path.GetExtension(fileImageUrl.PostedFile.FileName);

            IsImageUrl = SnSee.Module.File.FileInfo.Upload(_FileUploadBean, fileImageUrl.PostedFile.InputStream, FilePath, FileName, FileExName, true, fileImageUrl.PostedFile.ContentType);
            if (!IsImageUrl)
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "分类图示上传失败。请检查后重试！");
                return;
            }
            _ProductClassBean.ImageUrl = FilePath + "/" + FileName + FileExName;
            _ProductClassBean.ImageUrl = _ProductClassBean.ImageUrl.Replace("//", "/");
            IsUpImageUrl = true;
        }
        #endregion
        bool _Return = false;
        if (ProductClassID.HasValue)
        {//编辑
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            //如果有原标题图片，在重新指定上传标题图片时，删除原标题图片-取得原数据
            SnSee.Bean.ProductClassBean _ProductClassBeanImg = null;
            if (IsUpImageUrl)
            {
                _ProductClassBeanImg = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ProductClassID.Value);
            }

            _Return = SnSee.Factory.Factory.ProductClass.Update(_ProductClassBean, ProductClassID.Value);
            if (_Return)
            {
                //如果有原标题图片，在重新指定上传标题图片时，删除原标题图片-执行图片删除
                if (IsUpImageUrl)
                {
                    if (_ProductClassBeanImg != null && !string.IsNullOrEmpty(_ProductClassBeanImg.ImageUrl))
                    {
                        SnSee.Module.File.FileInfo.DeleteFile(_ProductClassBeanImg.ImageUrl);
                    }
                }

                _Return = SnSee.Module.Product.ProductClass.SetProductClassDepth(ProductClassID.Value, ParentID); //更新分类路径
            }
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);

            //更新分类路径
            if (ParentID.HasValue)
            {
                SnSee.Bean.ProductClassBean _ProductClassBeanParent = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ParentID.Value);
                if (_ProductClassBeanParent != null)
                {
                    _ProductClassBean.Depth = _ProductClassBeanParent.Depth + 1;
                    if (string.IsNullOrEmpty(_ProductClassBeanParent.DepthPath))
                    {
                        _ProductClassBean.DepthPath = "{" + ParentID.Value.ToString() + "}";
                    }
                    else
                    {
                        _ProductClassBean.DepthPath = _ProductClassBeanParent.DepthPath + ",{" + ParentID.Value + "}";
                    }
                }
            }
            _Return = SnSee.Factory.Factory.ProductClass.Insert(_ProductClassBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}
