﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ProductList.aspx.cs" Inherits="Admin_Product_ProductList"
    EnableViewState="true" %>

<%@ Register Src="../Controls/EditionItem.ascx" TagName="EditionItem" TagPrefix="uc2" %>
<%@ Register Assembly="SnSee.Control" Namespace="SnSee.Control" TagPrefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../Stylesheet/Main.css" rel="stylesheet" type="text/css" />

    <script src="../Javascript/Common.js" type="text/javascript" language="JavaScript"></script>

</head>
<body>
    <form id="form1" runat="server">
    <ul class="tool">
        <li onmousemove="this.className='tool_li_ac'" onmouseout="this.className=''">
            <img src="../Images/icon_add.gif" width="14" height="14" align="absmiddle" />
            <a href="Product.aspx?ProductClassParentID=<%=ProductClassParentID %>" title="增加产品">增加产品</a></li>
        <li>
            <div class="tool_back">
                <a href="javaScript:history.back(-1)">返回上一步</a></div>
        </li>
    </ul>
    <div class="main_body">
        <h1>
            <asp:Literal ID="litTitle" runat="server"></asp:Literal>产品管理</h1>
        <ul class="item_list">
            <li class="item_list_cell margin_left_2px">
                <div>
                    <a href="ProductBaseList.aspx?ProductClassParentID=<%=ProductClassParentID %>">产品基础资料</a>
                </div>
            </li>
            <li>
                <div>
                    <uc2:EditionItem ID="EditionItem1" runat="server" />
                </div>
            </li>
        </ul>
        <div class="ht2">
        </div>
        <div class="divbox">
            <div class="padding8px">
                <asp:Panel ID="pnlSearch" runat="server" DefaultButton="lbtnSearch">
                    <b>搜索：</b><asp:DropDownList ID="dropClass" runat="server" DataTextField="TreeMode"
                        DataValueField="ID">
                    </asp:DropDownList>
                    <asp:TextBox ID="txtKeyWord" runat="server" Width="160px"></asp:TextBox>
                    <asp:LinkButton ID="lbtnSearch" runat="server" CssClass="btn_bg" OnClick="lbtnSearch_Click">搜索产品</asp:LinkButton></asp:Panel>
            </div>
        </div>
        <div class="ht2">
        </div>
        <div class="divbox2">
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="tbbox">
                <tr>
                    <th width="3%" class="input_no">
                        <input id="Checkbox1" type="checkbox" onclick="UnSelectCheckBox(this,'chkSelect')" />
                    </th>
                    <th width="10%" id="boxPicPath3" runat="server">
                        产品图片
                    </th>
                    <th width="15%">
                        所属分类
                    </th>
                    <th>
                        产品名称
                    </th>
                    <th width="15%">
                        产品型号
                    </th>
                    <th width="10%" runat="server" id="boxProductPrice">
                        销售价格
                    </th>
                    <th width="8%">
                        状态
                    </th>
                    <th width="8%">
                        排序
                    </th>
                    <th width="7%">
                        操作
                    </th>
                </tr>
                <asp:Repeater ID="rptList" runat="server" OnItemCommand="rptList_ItemCommand">
                    <ItemTemplate>
                        <tr>
                            <td align="center" class="input_no">
                                <asp:Literal ID="litID" runat="server" Text='<%#Eval("ProductListID")%>' Visible="false"></asp:Literal>
                                <asp:CheckBox ID="chkSelect" runat="server" />
                            </td>
                            <td align="center" id="boxPicPath3" runat="server" visible="<%#SnSee.Config.ProductConfig.ProductPicPath3Open %>">
                                <img src="<%#Eval("PicPath3") %>" width="80" border="0" />
                            </td>
                            <td align="center">
                                <%#Eval("ClassName")%>
                            </td>
                            <td align="center">
                                <%#Eval("Name")%>
                            </td>
                            <td align="center">
                                <%#Eval("Model")%>
                            </td>
                            <td align="center" runat="server" id="boxProductPrice" visible="<%#SnSee.Config.ProductConfig.PriceOpen %>">
                                <%#Eval("Price") %>
                            </td>
                            <td align="center">
                                <%#Eval("State") != DBNull.Value && Eval("State").ToString()=="1" ? "启用":"未启用"%>
                            </td>
                            <td align="center">
                                <%#Eval("SortOrder") %>
                            </td>
                            <td align="center">
                                <a href="ProductEdition.aspx?ID=<%#Eval("ProductBaseID")%>&ProductClassParentID=<%=ProductClassParentID %>&EditionID=<%#Eval("EditionID")%>"
                                    title="编辑当前产品资料"><img src="../images/icon_bj.gif" border="0" align="absmiddle" /></a>
                                <asp:LinkButton ID="lbtnDel" runat="server" ToolTip="将当前产品放入回收站"
                                    CommandArgument='<%#Eval("ProductListID")%>' CommandName="Delete_Command" OnClientClick="return confirm('确认将当前产品放入回收站？')"><img src="../images/icon_hs.gif" border="0" align="absmiddle" /></asp:LinkButton>
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </table>
        </div>
        <div class="ht2">
        </div>
        <div class="padding4px">
            <input type="button" id="Button7" value="全选" onclick="SelectCheckBox(this, 'chkSelect',1)"
                class="btn_bg2" />
            <input type="button" id="Button8" value="反选" onclick="UnSelectCheckBox(this,'chkSelect')"
                class="btn_bg2" />
            <input type="button" id="Button9" value="取消选择" onclick="SelectCheckBox(this, 'chkSelect',2)"
                class="btn_bg2" />
            |
            <asp:Button ID="btnAllDel" runat="server" Text="放入回收站" CssClass="btn_bg2" OnClick="btnAllDel_Click"
                OnClientClick="return confirm('确认将当前选中产品放入回收站？')" ToolTip="将选中产品放入回收站" />
        </div>
        <div class="webpage">
            <cc1:WebPage ID="WebPage1" runat="server" PageSize="20">
            </cc1:WebPage>
        </div>
        <div class="ht">
        </div>
        <div class="ht">
        </div>
        <ul class="ac_intro" runat="server" id="boxPageExplain">
            <li class="ac_intro_title">说明：</li>
            <li class="ac_intro_item">1. 产品管理。</li>
        </ul>
    </div>
    </form>
</body>
</html>
