﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Product_ProductPic : System.Web.UI.Page
{
    protected Guid? ProductBaseID;
    protected Guid? EditionID;
    protected Guid? ProductClassParentID;
    protected Guid? ProductPicBaseID;
    AdminBaseBean _AdminBeanLogin = null;
    private string SearchKeyword;
    private Guid? ProductPicClassID;
    private string Where;
    private string Action;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product) || !SnSee.Config.ProductConfig.OtherPicOpen)
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0104", true);
        ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        ProductClassParentID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductClassParentID"]);
        ProductPicBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductPicBaseID"]);
        SearchKeyword = Request.QueryString["Keyword"];
        ProductPicClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductPicClassID"]);
        Action = Request.QueryString["Ac"];

        if (!ProductBaseID.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未完成第一步：产品基本资料", "Product.aspx?ProductClassParentID=" + ProductClassParentID);
            return;
        }

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = ProductBaseID;
        EditionItem1.NavName = "ProductPic";
        EditionItem1.NavDir = "Product";
        EditionItem1.UrlParameter = "ProductPicBaseID=" + ProductPicBaseID + "&ProductClassParentID=" + ProductClassParentID + "&Ac=PicInfo";

        EditionItem2.EditionID = EditionID;
        EditionItem2.ObjectID = ProductBaseID;
        EditionItem2.NavName = "ProductPic";
        EditionItem2.NavDir = "Product";
        EditionItem2.UrlParameter = "ProductPicBaseID=" + ProductPicBaseID + "&ProductClassParentID=" + ProductClassParentID + "";

        if (!string.IsNullOrEmpty(Action))
        {
            switch (Action)
            {
                case "Pic":
                    pnlTitlePic.Attributes.Remove("class");
                    pnlTitlePic.Attributes.Add("class", "item_list_cell_ac");
                    pnlTitlePicInfo.Attributes.Remove("class");
                    pnlTitlePicInfo.Attributes.Add("class", "item_list_cell margin_left_2px");
                    pnlPicAll.Visible = true;
                    pnlPic.Visible = true;
                    pnlPicList.Visible = false;

                    if (!IsPostBack)
                    {
                        if (ProductPicBaseID.HasValue)
                        {
                            LoadProductPic(ProductPicBaseID.Value);
                        }
                    }
                    break;
                case "PicInfo":
                    pnlTitlePic.Attributes.Remove("class");
                    pnlTitlePic.Attributes.Add("class", "item_list_cell");
                    pnlTitlePicInfo.Attributes.Remove("class");
                    pnlTitlePicInfo.Attributes.Add("class", "item_list_cell_ac margin_left_2px");
                    if (!ProductPicBaseID.HasValue)
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未上传图片！", "ProductPic.aspx?ID=" + ProductBaseID.Value + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID + "&Ac=Pic");
                        return;
                    }
                    pnlPicAll.Visible = true;
                    pnlPicInfo.Visible = true;
                    pnlPicList.Visible = false;

                    if (!IsPostBack)
                    {
                        if (EditionID.HasValue && ProductPicBaseID.HasValue)
                        {
                            LoadProductPicInfo(ProductPicBaseID.Value, EditionID.Value);
                        }
                    }
                    break;
            }
        }

        if (!IsPostBack)
        {
            GetProductModuleConfig();
            if (EditionID.HasValue)
            {
                dropProductPicClass_DataBind(EditionID.Value);
                if (ProductBaseID.HasValue)
                {
                    boxDel.Visible = true;
                    Where = "ProductPicList.State=1 And ProductPicList.ProductBaseID='{" + ProductBaseID.Value + "}' And ProductPicList.EditionID='{" + EditionID.Value + "}'";
                    if (ProductPicClassID.HasValue)
                    {
                        Where += " And ProductPicList.ProductPicClassID='{" + ProductPicClassID.Value + "}'";
                    }
                    if (!string.IsNullOrEmpty(SearchKeyword))
                    {
                        Where += " And ProductPicList.Title Like '%" + SearchKeyword + "%'";
                    }
                }

                rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By ProductPicList.SortOrder Asc, ProductPicList.CreateTime Desc");
            }
        }
        if (ProductClassParentID.HasValue)
        {
            GetProductClassParent(ProductClassParentID.Value);
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        chkIsMakeProductPicPath1.Visible = pnlPicPath1.Visible = SnSee.Config.ProductConfig.ProductOtherPicPath1Open;
        chkIsMakeProductPicPath2.Visible = pnlPicPath2.Visible = SnSee.Config.ProductConfig.ProductOtherPicPath2Open;
        chkIsMakeProductPicPath3.Visible = pnlPicPath3.Visible = SnSee.Config.ProductConfig.ProductOtherPicPath3Open;
        boxOtherPicPath3.Visible = SnSee.Config.ProductConfig.ProductOtherPicPath3Open;

        if (SnSee.Config.ProductConfig.MakeProductOtherPicPath2Open)
        {
            pnlPicPath2.Attributes.Add("style", "display:none;");
        }
        if (SnSee.Config.ProductConfig.MakeProductOtherPicPath3Open)
        {
            pnlPicPath3.Attributes.Add("style", "display:none;");
        }

        chkIsMakeProductPicPath1.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath1Open;
        chkIsMakeProductPicPath2.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath2Open;
        chkIsMakeProductPicPath3.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath3Open;

        chkIsMakeProductPicPath1.Text = "自动生成大图(" + SnSee.Config.ProductConfig.ProductOtherPicPath1Width + "×" + SnSee.Config.ProductConfig.ProductOtherPicPath1Height + ")";
        chkIsMakeProductPicPath2.Text = "自动生成中图(" + SnSee.Config.ProductConfig.ProductOtherPicPath2Width + "×" + SnSee.Config.ProductConfig.ProductOtherPicPath2Height + ")";
        chkIsMakeProductPicPath3.Text = "自动生成小图(" + SnSee.Config.ProductConfig.ProductOtherPicPath3Width + "×" + SnSee.Config.ProductConfig.ProductOtherPicPath3Height + ")";

        litMustProductPicPath1.Visible = SnSee.Config.ProductConfig.MustProductOtherPicPath1;
        litMustProductPicPath2.Visible = SnSee.Config.ProductConfig.MustProductOtherPicPath2;
        litMustProductPicPath3.Visible = SnSee.Config.ProductConfig.MustProductOtherPicPath3;
    }

    /// <summary>
    /// 取得产品分类父级数据
    /// </summary>
    /// <param name="ID">父级分类ID</param>
    private void GetProductClassParent(Guid ID)
    {
        SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ID);
        if (_ProductClassBean != null)
        {
            litTitle.Text = _ProductClassBean.ClassName + "管理 -> " + litTitle.Text;
        }
    }

    /// <summary>
    /// 绑定产品图片分类数据
    /// </summary>
    /// <param name="EditionID">语言版本标识ID</param>
    private void dropProductPicClass_DataBind(Guid EditionID)
    {
        DataTable dt = SnSee.Module.Product.ProductPicClassTree.GetClassTreeList(null, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder Asc, CreateTime Asc");
        dropProductPicClass.DataSource = dt;
        dropProductPicClass.DataBind();

        dropProductPicClass2.DataSource = dt;
        dropProductPicClass2.DataBind();
        dropProductPicClass2.Items.Insert(0, new ListItem("全部", ""));
    }

    /// <summary>
    /// 载入图片内容
    /// </summary>
    /// <param name="ProductPicID">产品相关图片ID</param>
    private void LoadProductPic(Guid ProductPicBaseID)
    {
        ProductPicBaseBean _ProductPicBean = (ProductPicBaseBean)SnSee.Factory.Factory.ProductPicBase.Select(ProductPicBaseID);
        if (_ProductPicBean != null)
        {
            if (!string.IsNullOrEmpty(_ProductPicBean.PicPath1))
            {
                boxPicPath1.Visible = true;
                imgPicPath1.ImageUrl = _ProductPicBean.PicPath1;
            }
            if (!string.IsNullOrEmpty(_ProductPicBean.PicPath2))
            {
                boxPicPath2.Visible = true;
                imgPicPath2.ImageUrl = _ProductPicBean.PicPath2;
            }
            if (!string.IsNullOrEmpty(_ProductPicBean.PicPath3))
            {
                boxPicPath3.Visible = true;
                imgPicPath3.ImageUrl = _ProductPicBean.PicPath3;
            }
        }
    }

    /// <summary>
    /// 载入图片资料内容
    /// </summary>
    /// <param name="ProductPicID">产品相关图片ID</param>
    /// <param name="EditionID">语言版本标识ID</param>
    private void LoadProductPicInfo(Guid ProductPicBaseID, Guid EditionID)
    {
        ProductPicListBean _ProductPicListBean = (ProductPicListBean)SnSee.Factory.Factory.ProductPicList.Select("ProductPicBaseID='{" + ProductPicBaseID + "}' And EditionID='{" + EditionID + "}'");
        if (_ProductPicListBean != null)
        {
            txtTitle.Text = _ProductPicListBean.Title;
            txtBody.Value = _ProductPicListBean.Body;
            if (_ProductPicListBean.SortOrder.HasValue)
            {
                txtSortOrder.Text = _ProductPicListBean.SortOrder.Value.ToString();
            }
            dropState.SelectedValue = _ProductPicListBean.State.Value.ToString();
        }
    }

    /// <summary>
    /// 上传图片
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSavePic_Click(object sender, EventArgs e)
    {
        string FilePath1 = string.Empty, FilePath2 = string.Empty, FilePath3 = string.Empty;
        bool IsFileUp = true;
        ProductPicBaseBean _ProductPicBaseBean = new ProductPicBaseBean();

        #region 文件上传
        //大图
        if (SnSee.Config.ProductConfig.MustProductOtherPicPath1 && (fuPicPath1.PostedFile == null || fuPicPath1.PostedFile.ContentLength <= 0) && SnSee.Config.ProductConfig.ProductOtherPicPath1Open)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择大图文件！", Request.RawUrl);
            return;
        }
        //中图
        if (SnSee.Config.ProductConfig.MustProductOtherPicPath2 && (fuPicPath2.PostedFile == null || fuPicPath2.PostedFile.ContentLength <= 0) && SnSee.Config.ProductConfig.ProductOtherPicPath2Open && !chkIsMakeProductPicPath2.Checked)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择中图文件！", Request.RawUrl);
            return;
        }
        //小图
        if (SnSee.Config.ProductConfig.MustProductOtherPicPath3 && (fuPicPath3.PostedFile == null || fuPicPath3.PostedFile.ContentLength <= 0) && SnSee.Config.ProductConfig.ProductOtherPicPath3Open && !chkIsMakeProductPicPath3.Checked)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择小图文件！", Request.RawUrl);
            return;
        }

        string PicPathFileName = Guid.NewGuid().ToString();  //文件名，公用于大、中、小图
        string PicPathFilePath = SnSee.Config.WebConfig.UploadFilePath + "/" + SnSee.Module.File.FileInfo.GetFilePath();//文件目录路径，公用于大、中、小图
        FilePath1 = PicPathFilePath + "/" + PicPathFileName + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //大图文件全部路径
        FilePath2 = PicPathFilePath + "/" + PicPathFileName + "_m" + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //中图文件全部路径
        FilePath3 = PicPathFilePath + "/" + PicPathFileName + "_s" + System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName);    //小图文件全部路径

        PicPathFilePath = PicPathFilePath.Replace("//", "/");
        FilePath1 = FilePath1.Replace("//", "/");
        FilePath2 = FilePath2.Replace("//", "/");
        FilePath3 = FilePath3.Replace("//", "/");

        //上传大图
        if (fuPicPath1.PostedFile != null && fuPicPath1.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath1Open)
        {
            FileUploadBean _FileUploadBean = new FileUploadBean();
            if (chkIsMakeProductPicPath1.Checked)
            {//根据选择的大图片自动生成大图 
                _FileUploadBean.IsDispose = true;
                _FileUploadBean.Width = SnSee.Config.ProductConfig.ProductPicPath1Width;
                _FileUploadBean.Height = SnSee.Config.ProductConfig.ProductPicPath1Height;
            }
            if (chkIsMakeProductPicPath2.Checked && SnSee.Config.ProductConfig.ProductPicPath2Open)
            {//根据选择的大图片自动生成中图
                FileUploadBean _FileUploadBean2 = new FileUploadBean();
                _FileUploadBean2.IsDispose = true;
                _FileUploadBean2.Width = SnSee.Config.ProductConfig.ProductPicPath2Width;
                _FileUploadBean2.Height = SnSee.Config.ProductConfig.ProductPicPath2Height;

                if (!SnSee.Module.File.FileInfo.Upload(_FileUploadBean2, fuPicPath1.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_m", System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName), true, fuPicPath1.PostedFile.ContentType))
                {
                    IsFileUp = false;
                }
            }
            if (chkIsMakeProductPicPath3.Checked && SnSee.Config.ProductConfig.ProductPicPath3Open)
            {//根据选择的大图片自动生成小图
                _FileUploadBean.IsMiniature = true;
                _FileUploadBean.MiniWidth = SnSee.Config.ProductConfig.ProductPicPath3Width;
                _FileUploadBean.MiniHeight = SnSee.Config.ProductConfig.ProductPicPath3Height;
            }

            if (!SnSee.Module.File.FileInfo.Upload(_FileUploadBean, fuPicPath1.PostedFile.InputStream, PicPathFilePath, PicPathFileName, System.IO.Path.GetExtension(fuPicPath1.PostedFile.FileName), true, fuPicPath1.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        //上传中图，当有选择中图文件+中图已经启用+不自动生成中图
        if (fuPicPath2.PostedFile != null && fuPicPath2.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath2Open && !chkIsMakeProductPicPath2.Checked)
        {
            if (!SnSee.Module.File.FileInfo.Upload(null, fuPicPath2.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_m", System.IO.Path.GetExtension(fuPicPath2.PostedFile.FileName), true, fuPicPath2.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        //当有选择小图文件+小图已经启用+不自动生成小图
        if (fuPicPath3.PostedFile != null && fuPicPath3.PostedFile.ContentLength > 0 && SnSee.Config.ProductConfig.ProductPicPath3Open && !chkIsMakeProductPicPath3.Checked)
        {//上传小图
            if (!SnSee.Module.File.FileInfo.Upload(null, fuPicPath3.PostedFile.InputStream, PicPathFilePath, PicPathFileName + "_s", System.IO.Path.GetExtension(fuPicPath3.PostedFile.FileName), true, fuPicPath3.PostedFile.ContentType))
            {
                IsFileUp = false;
            }
        }

        if (!IsFileUp)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片上传失败，请检查后重试！", Request.RawUrl);
            return;
        }
        #endregion

        if (!string.IsNullOrEmpty(FilePath1))
        {
            _ProductPicBaseBean.PicPath1 = FilePath1;
        }
        if (!string.IsNullOrEmpty(FilePath2))
        {
            _ProductPicBaseBean.PicPath2 = FilePath2;
        }
        if (!string.IsNullOrEmpty(FilePath3))
        {
            _ProductPicBaseBean.PicPath3 = FilePath3;
        }

        if (string.IsNullOrEmpty(_ProductPicBaseBean.PicPath1) && string.IsNullOrEmpty(_ProductPicBaseBean.PicPath2) && string.IsNullOrEmpty(_ProductPicBaseBean.PicPath3))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "图片上传失败或者您还没有选择要上传的图片，请检查后重试！", Request.RawUrl);
            return;
        }

        ProductPicBaseBean _ProductPicBaseBeanCheck = null;
        if (ProductPicBaseID.HasValue)
        {
            _ProductPicBaseBeanCheck = (ProductPicBaseBean)SnSee.Factory.Factory.ProductPicBase.Select("ID='{" + ProductPicBaseID.Value + "}'");
        }

        if (ProductPicBaseID.HasValue && _ProductPicBaseBeanCheck != null)
        {//编辑
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            if (SnSee.Factory.Factory.ProductPicBase.Update(_ProductPicBaseBean, ProductPicBaseID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品图片编辑成功！", "ProductPic.aspx?ID=" + ProductBaseID + "&ProductPicBaseID=" + _ProductPicBaseBean.ID + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID);
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片编辑失败，请检查后重试！", Request.RawUrl);
                return;
            }
        }
        else
        {//增加
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);
            _ProductPicBaseBean.ID = ProductPicBaseID;
            _ProductPicBaseBean.ProductBaseID = ProductBaseID;
            if (SnSee.Factory.Factory.ProductPicBase.Insert(_ProductPicBaseBean))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，图片上传成功，进入下一步：图片资料", "ProductPic.aspx?ID=" + ProductBaseID + "&ProductPicBaseID=" + _ProductPicBaseBean.ID + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID + "&Ac=PicInfo");
            }
            else
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片增加失败，请检查后重试！", Request.RawUrl);
                return;
            }
        }
    }

    /// <summary>
    /// 保存产品相关图片资料
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSavePicInfo_Click(object sender, EventArgs e)
    {
        Guid? ProductPicClassID = SnSee.Tool.ConvertTool.GetGuid(dropProductPicClass.SelectedValue);
        if (!ProductPicClassID.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择图片分类！");
            return;
        }

        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);
        if (!SortOrder.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的排序值不合格，只能输入整数！");
            return;
        }

        ProductPicListBean _ProductPicListBean = new ProductPicListBean();
        _ProductPicListBean.ProductPicClassID = ProductPicClassID;
        _ProductPicListBean.Title = txtTitle.Text;
        _ProductPicListBean.Body = txtBody.Value;
        _ProductPicListBean.SortOrder = SortOrder;
        _ProductPicListBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        ProductPicListBean _ProductPicListBeanCheck = null;
        if (ProductPicBaseID.HasValue)
        {
            _ProductPicListBeanCheck = (ProductPicListBean)SnSee.Factory.Factory.ProductPicList.Select("EditionID='{" + EditionID.Value + "}' And ProductPicBaseID='{" + ProductPicBaseID.Value + "}'");
        }

        bool _Return = false;
        if (_ProductPicListBeanCheck == null || !ProductBaseID.HasValue)
        {//增加
            _ProductPicListBean.EditionID = EditionID;
            _ProductPicListBean.ProductPicBaseID = ProductPicBaseID;
            _ProductPicListBean.ProductBaseID = ProductBaseID;
            _Return = SnSee.Factory.Factory.ProductPicList.Insert(_ProductPicListBean);
        }
        else
        {//编辑
            _Return = SnSee.Factory.Factory.ProductPicList.Update(_ProductPicListBean, "EditionID='{" + EditionID.Value + "}' And ProductPicBaseID='{" + ProductPicBaseID.Value + "}'");
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "ProductPic.aspx?ID=" + ProductBaseID.Value + "&ProductPicBaseID=" + ProductPicBaseID.Value + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID.Value + "&Ac=PicInfo");
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }

    /// <summary>
    /// 取得列表
    /// </summary>
    /// <param name="_PageIndex"></param>
    /// <param name="_PageSize"></param>
    /// <param name="_Where"></param>
    /// <param name="_OrderBy"></param>
    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ProductPicBase.GetProductPicListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? ProductPicListID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!ProductPicListID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://彻底删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                if (SnSee.Factory.Factory.ProductPicList.Delete(ProductPicListID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品图片彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品图片彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 当前产品图片放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        if (ProductBaseID.HasValue)
        {
            ProductListBean _ProductListBean = new ProductListBean();
            _ProductListBean.State = 0;
            if (SnSee.Factory.Factory.ProductList.Update(_ProductListBean, "ProductBaseID='{" + ProductBaseID.Value + "}'"))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "ProductList.aspx?ProductClassParentID=" + ProductClassParentID + "&EID=" + EditionID);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "数据错误，无法进行删除！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("ProductPic.aspx?ID=" + ProductBaseID.Value + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID.Value + "&Keyword=" + txtKeyword.Text + "&ProductPicClassID=" + dropProductPicClass2.SelectedValue);
    }
}
