﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Product_ProductPicBaseList : System.Web.UI.Page
{
    protected Guid? ProductBaseID;
    protected Guid? EditionID;
    protected Guid? ProductClassParentID;
    AdminBaseBean _AdminBeanLogin = null;
    private string Where;
    private int EditionMaxNum = 0;
    private string EditionWhere = "";
    private string EditionOrderBy = "Order By SortOrder Asc, CreateTime Asc";

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product) || !SnSee.Config.ProductConfig.OtherPicOpen)
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0104", true);
        ProductClassParentID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductClassParentID"]);
        ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);

        if (!ProductBaseID.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未完成第一步：产品基本资料", "Product.aspx?ProductClassParentID=" + ProductClassParentID);
            return;
        }

        EditionItem2.EditionID = EditionID;
        EditionItem2.ObjectID = ProductBaseID;
        EditionItem2.NavName = "ProductPic";
        EditionItem2.NavDir = "Product";
        EditionItem2.UrlParameter = "&ProductClassParentID=" + ProductClassParentID;
        if (!IsPostBack)
        {
            rptEditionList_DataBind(EditionMaxNum, EditionWhere, EditionOrderBy);
            if (ProductBaseID.HasValue)
            {
                boxDel.Visible = true;
                Where = "ProductBaseID='{" + ProductBaseID.Value + "}'";
            }

            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By CreateTime Desc");
        }
        if (ProductClassParentID.HasValue)
        {
            GetProductClassParent(ProductClassParentID.Value);
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得语言版本资料
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序</param>
    private void rptEditionList_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        rptEditionList.DataSource = SnSee.Factory.Factory.Edition.SelectList(_MaxNum, _Where, _OrderBy);
        rptEditionList.DataBind();
    }

    /// <summary>
    /// 取得产品分类父级数据
    /// </summary>
    /// <param name="ID">父级分类ID</param>
    private void GetProductClassParent(Guid ID)
    {
        SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ID);
        if (_ProductClassBean != null)
        {
            litTitle.Text = _ProductClassBean.ClassName + "管理 -> " + litTitle.Text;
        }
    }

    /// <summary>
    /// 取得列表
    /// </summary>
    /// <param name="_PageIndex"></param>
    /// <param name="_PageSize"></param>
    /// <param name="_Where"></param>
    /// <param name="_OrderBy"></param>
    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ProductPicBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Repeater rptEditionList = (Repeater)e.Item.FindControl("rptEditionList");
            if (rptEditionList != null)
            {
                rptEditionList.DataSource = SnSee.Factory.Factory.Edition.SelectList(EditionMaxNum, EditionWhere, EditionOrderBy);
                rptEditionList.DataBind();
            }
        }
    }

    protected void rptEditionList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            HyperLink hlkLink = (HyperLink)e.Item.FindControl("hlkLink");
            Control parentRptList = e.Item.Parent.Parent;

            SnSee.Bean.EditionBean _EditionBean = (SnSee.Bean.EditionBean)e.Item.DataItem;
            if (_EditionBean == null)
            {
                return;
            }

            if (parentRptList != null)
            {
                Guid? ProductBaseID = null, ProductPicBaseID = null;
                Literal litProductBaseID = (Literal)parentRptList.FindControl("litProductBaseID");
                Literal litID = (Literal)parentRptList.FindControl("litID");

                if (litProductBaseID != null)
                {
                    ProductBaseID = SnSee.Tool.ConvertTool.GetGuid(litProductBaseID.Text);
                    ProductPicBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);

                    if (ProductBaseID.HasValue)
                    {
                        //检查当前语言版本是否已经增加过产品资料
                        SnSee.Bean.ProductPicListBean _ProductPicListBean = (SnSee.Bean.ProductPicListBean)SnSee.Factory.Factory.ProductPicList.Select("ProductBaseID='{" + ProductBaseID.Value + "}' And EditionID='{" + _EditionBean.ID.Value + "}' And ProductPicBaseID='{" + ProductPicBaseID + "}'");
                        if (_ProductPicListBean != null)
                        {//能找到数据，说明已经增加过 
                            hlkLink.ImageUrl = "../images/icon_ok.gif";
                            hlkLink.ToolTip = "已添加当前对应语言版本的图片资料；点击可直接对其编辑";
                            hlkLink.NavigateUrl = "ProductPic.aspx?ID=" + ProductBaseID.Value + "&ProductPicBaseID=" + ProductPicBaseID + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + _EditionBean.ID + "&Ac=PicInfo";
                        }
                        else
                        {//未增加
                            hlkLink.ImageUrl = "../images/icon_nook.gif";
                            hlkLink.ToolTip = "未添加当前对应语言版本的图片资料；点击可直接对其添加";
                            hlkLink.NavigateUrl = "ProductPic.aspx?ID=" + ProductBaseID.Value + "&ProductPicBaseID=" + ProductPicBaseID + "&ProductClassParentID=" + ProductClassParentID + "&EditionID=" + _EditionBean.ID + "&Ac=PicInfo";
                        }
                    }
                }
            }
        }
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? ProductPicBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!ProductPicBaseID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://放入回收站 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                SnSee.Bean.ProductPicBaseBean _ProductPicBaseBean = (SnSee.Bean.ProductPicBaseBean)SnSee.Factory.Factory.ProductPicBase.Select(ProductPicBaseID.Value);
                if (_ProductPicBaseBean != null)
                {
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductPicBaseBean.PicPath1);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductPicBaseBean.PicPath2);
                    SnSee.Module.File.FileInfo.DeleteFile(_ProductPicBaseBean.PicPath3);
                }

                SnSee.Factory.Factory.ProductPicList.Delete("ProductBaseID='{" + ProductBaseID + "}' And ProductPicBaseID='{" + ProductPicBaseID + "}'");

                if (SnSee.Factory.Factory.ProductPicBase.Delete(ProductPicBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，图片彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "图片彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 当前产品图片放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        if (ProductBaseID.HasValue)
        {
            ProductListBean _ProductListBean = new ProductListBean();
            _ProductListBean.State = 0;
            if (SnSee.Factory.Factory.ProductList.Update(_ProductListBean, "ProductBaseID='{" + ProductBaseID.Value + "}'"))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "ProductList.aspx?ProductClassParentID=" + ProductClassParentID + "&EditionID=" + EditionID);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "数据错误，无法进行删除！", Request.RawUrl);
        }
    }
}
