﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Product_ProductPicClassSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? ProductPicClassID;
    private string ActionType;
    private Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        ActionType = Request["AC"];
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        ProductPicClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionItem1.NavName = "ProductPicClassSet";
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = ProductPicClassID;
        EditionItem1.NavDir = "Product";

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value);
                if (EditionID.HasValue && ProductPicClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
                {
                    SetProductPicClassData(EditionID.Value, ProductPicClassID.Value);
                }
            }
            rptList_DataBind();
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
            litTitle3.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入指定ID的版本的分类数据
    /// </summary>
    /// <param name="EditiionID">语言版本ID</param>
    /// <param name="ID">分类ID</param>
    private void SetProductPicClassData(Guid EditionID, Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        ProductPicClassBean _ProductPicClassBean = (ProductPicClassBean)SnSee.Factory.Factory.ProductPicClass.Select("EditionID='{" + EditionID + "}' and ID='{" + ID + "}'");
        if (_ProductPicClassBean != null)
        {
            if (_ProductPicClassBean.ParentID.HasValue)
            {
                dropClass.SelectedValue = _ProductPicClassBean.ParentID.Value.ToString();
            }
            txtClassName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductPicClassBean.ClassName);
            txtClassKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ProductPicClassBean.ClassKey);
            dropState.SelectedValue = _ProductPicClassBean.State.Value.ToString();
            txtSortOrder.Text = _ProductPicClassBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入当前版本产品分类列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Module.Product.ProductPicClassTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        rptList.DataBind();
    }

    /// <summary>
    /// 载入分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        DataTable dt = null;
        if (ProductPicClassID.HasValue)
        {
            dt = SnSee.Module.Product.ProductPicClassTree.GetClassTreeList(null, ProductPicClassID.Value, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        }
        else
        {
            dt = SnSee.Module.Product.ProductPicClassTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        }

        dropClass.DataSource = dt;
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcProductPicClassID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcProductPicClassID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                List<object> _ProductPicListBeanList = SnSee.Factory.Factory.ProductPicList.SelectList(0, "ProductPicClassID='{" + AcProductPicClassID.Value + "}'", "");
                if (_ProductPicListBeanList != null && _ProductPicListBeanList.Count > 0)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "当前产品图片分类存在相关产品图片，不能进行删除，请将当前分类中的相关产品图片清除掉后再执行此操作！", Request.Url.ToString());
                }

                if (SnSee.Factory.Factory.ProductPicClass.Delete(AcProductPicClassID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Literal litClass = (Literal)e.Item.FindControl("litClass");
            DataRowView drv = (DataRowView)e.Item.DataItem;
            if (drv != null)
            {
                if (drv["ParentID"] != null && !string.IsNullOrEmpty(drv["ParentID"].ToString()))
                {
                    ProductPicClassBean _ProductPicClassBeanLoad = (ProductPicClassBean)SnSee.Factory.Factory.ProductPicClass.Select(new Guid(drv["ParentID"].ToString()));
                    if (_ProductPicClassBeanLoad != null && litClass != null)
                    {
                        litClass.Text = _ProductPicClassBeanLoad.ClassName;
                    }
                }
            }
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        Guid? ParentID = SnSee.Tool.ConvertTool.GetGuid(dropClass.SelectedValue);
        string ClassName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassName.Text);
        string ClassKey = SnSee.Tool.EncodeTool.HtmlEncode(txtClassKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (string.IsNullOrEmpty(ClassName) || string.IsNullOrEmpty(ClassKey))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入语言版本名称或版本标识！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "ClassKey='" + ClassKey + "'";
        if (ProductPicClassID.HasValue)
        {
            Where += " And ClassKey<>'" + ClassKey + "'";
        }
        ProductPicClassBean _ProductPicClassBeanCheck = (ProductPicClassBean)SnSee.Factory.Factory.ProductPicClass.Select(Where);
        if (_ProductPicClassBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的版本标识，请更换另一个后重试操作！");
            return;
        }

        ProductPicClassBean _ProductPicClassBean = new ProductPicClassBean();
        _ProductPicClassBean.EditionID = EditionID;
        _ProductPicClassBean.ClassName = ClassName;
        _ProductPicClassBean.ClassKey = ClassKey;
        _ProductPicClassBean.State = State;
        _ProductPicClassBean.SortOrder = SortOrder;
        _ProductPicClassBean.Depth = 1;
        if (ParentID.HasValue)
        {
            _ProductPicClassBean.DepthPath = ParentID.Value.ToString();
            ProductPicClassBean _ProductPicClassBeanParent = (ProductPicClassBean)SnSee.Factory.Factory.ProductPicClass.Select(ParentID.Value);
            if (_ProductPicClassBeanParent != null)
            {
                _ProductPicClassBean.ParentID = ParentID;
                _ProductPicClassBean.Depth = _ProductPicClassBeanParent.Depth + 1;
                if (string.IsNullOrEmpty(_ProductPicClassBeanParent.DepthPath))
                {
                    _ProductPicClassBean.DepthPath = "{" + ParentID.Value.ToString() + "}";
                }
                else
                {
                    _ProductPicClassBean.DepthPath = _ProductPicClassBeanParent.DepthPath + ",{" + ParentID.Value + "}";
                }
            }
        }

        bool _Return = false;
        if (ProductPicClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0103", true);
            _Return = SnSee.Factory.Factory.ProductPicClass.Update(_ProductPicClassBean, ProductPicClassID.Value);
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0101", true);
            _Return = SnSee.Factory.Factory.ProductPicClass.Insert(_ProductPicClassBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}
