﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Product_ProductRecycleList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    protected Guid? ProductClassParentID;
    private Guid? ProductClassID;
    private string Keyword;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Product))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0105", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        ProductClassParentID = SnSee.Tool.ConvertTool.GetGuid(Request["ProductClassParentID"]);
        ProductClassID = SnSee.Tool.ConvertTool.GetGuid(Request["CID"]);
        Keyword = Request.QueryString["Key"];

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        Where = "ProductList.[State]=0 And ProductClass.[EditionID]='{" + EditionID.Value + "}'";
        if (ProductClassParentID.HasValue)
        {
            Where += " And (ProductClass.ID='{" + ProductClassParentID.Value + "}' Or ProductClass.[DepthPath] Like '%" + ProductClassParentID.Value + "%') ";
        }
        if (ProductClassID.HasValue)
        {
            Where += " And (ProductClass.ID='{" + ProductClassID.Value + "}' Or ProductClass.[DepthPath] Like '%" + ProductClassID.Value + "%') ";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.EncodeTool.HtmlEncode(Keyword);
            Where += " And (ProductList.[Name] Like '%" + Keyword + "%' Or ProductList.[Model] Like '%" + Keyword + "%') ";
        }

        EditionItem1.NavName = "ProductRecycleList";
        EditionItem1.NavDir = "Product";
        EditionItem1.EditionID = EditionID;
        EditionItem1.UrlParameter = "&ProductClassParentID=" + ProductClassParentID;

        GetProductModuleConfig();
        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value, ProductClassParentID);
            }

            if (ProductClassID.HasValue)
            {
                dropClass.SelectedValue = ProductClassID.Value.ToString();
            }
            if (!string.IsNullOrEmpty(Keyword))
            {
                txtKeyWord.Text = Keyword;
            }
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By ProductList.SortOrder Asc, ProductList.CreateTime Desc");
        }
        if (ProductClassParentID.HasValue)
        {
            GetProductClassParent(ProductClassParentID.Value);
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 取得产品分类父级数据
    /// </summary>
    /// <param name="ID">父级分类ID</param>
    private void GetProductClassParent(Guid ID)
    {
        SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select(ID);
        if (_ProductClassBean != null)
        {
            litTitle.Text = _ProductClassBean.ClassName + "管理 -> " + litTitle.Text;
        }
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID, Guid? ParentID)
    {
        dropClass.DataSource = SnSee.Module.Product.ProductClassTree.GetClassTreeList(ParentID, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder asc, CreateTime Desc");
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    /// <summary>
    /// 取得产品模块配置
    /// </summary>
    private void GetProductModuleConfig()
    {
        boxPicPath3.Visible = SnSee.Config.ProductConfig.ProductPicPath3Open;
        boxProductPrice.Visible = SnSee.Config.ProductConfig.PriceOpen;    //价格体系是否启用
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ProductBase.GetProductListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }


    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? ProductListID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!ProductListID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "canceldelete_command"://还原 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                ProductListBean _ProductListBean = new ProductListBean();
                _ProductListBean.State = 1;
                if (SnSee.Factory.Factory.ProductList.Update(_ProductListBean, ProductListID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品还原成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品还原失败，请重试！", Request.RawUrl);
                }
                break;
            case "delete_command"://彻底删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
                if (SnSee.Factory.Factory.ProductList.Delete(ProductListID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，产品彻底删除成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "产品彻底删除失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 搜索产品
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("ProductRecycleList.aspx?EditionID=" + EditionID + "&CID=" + dropClass.SelectedValue + "&ProductClassParentID=" + ProductClassParentID + "&Key=" + txtKeyWord.Text);
    }

    /// <summary>
    /// 批量彻底删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _ProductListID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _ProductListID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得产品列表ID

            if (chkSelect.Checked && _ProductListID.HasValue)
            {
                if (!SnSee.Factory.Factory.ProductList.Delete(_ProductListID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选产品彻底删除成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选产品彻底删除存在失败，请核查后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 批量还原
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancelDelete_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0102", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _ProductListID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _ProductListID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得产品列表ID

            if (chkSelect.Checked && _ProductListID.HasValue)
            {
                ProductListBean _ProductListBean = new ProductListBean();
                _ProductListBean.State = 1;
                if (!SnSee.Factory.Factory.ProductList.Update(_ProductListBean, _ProductListID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选产品还原成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选产品还原存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}