﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Admin_Sales_Sales : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    protected Guid? SalesBaseID;
    protected Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Sales))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0304", true);
        SalesBaseID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = SalesBaseID;
        EditionItem1.NavName = "Sales";

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                dropClass_DataBind(EditionID.Value);
            }

            if (SalesBaseID.HasValue)
            {
                boxDel.Visible = true;
                litTitle.Text = "编辑销售网络";
                EditionItem1.IsViewCellEditionID = true;
                LoadSalesBase(SalesBaseID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        dropClass.DataSource = SnSee.Module.Sales.SalesClassTree.GetClassTreeList(null, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder Asc, CreateTime Asc");
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    /// <summary>
    /// 载入内容
    /// </summary>
    /// <param name="EditionID">版本ID</param>
    /// <param name="SalesID">销售网络ID</param>
    private void LoadSalesBase(Guid SalesBaseID)
    {
        SalesBaseBean _SalesBaseBean = (SalesBaseBean)SnSee.Factory.Factory.SalesBase.Select(SalesBaseID);
        if (_SalesBaseBean != null)
        {
            dropClass.SelectedValue = _SalesBaseBean.SalesClassID.Value.ToString();
            txtTitle.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesBaseBean.Title);
            txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesBaseBean.Address);
            txtContact.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesBaseBean.Contact);
            txtTelephone.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesBaseBean.Telephone);
            txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesBaseBean.Email);
            txtBody.Value = _SalesBaseBean.Body;
            txtSortOrder.Text = _SalesBaseBean.SortOrder.HasValue ? _SalesBaseBean.SortOrder.Value.ToString() : "";
            dropState.SelectedValue = _SalesBaseBean.State.HasValue ? _SalesBaseBean.State.Value.ToString() : "0";
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);
        if (!SortOrder.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您输入的排序值不合格，只能输入整数！");
            return;
        }

        string Title = SnSee.Tool.EncodeTool.HtmlEncode(txtTitle.Text);
        Guid? SalesClassID = SnSee.Tool.ConvertTool.GetGuid(dropClass.SelectedValue);
        string Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        string Contact = SnSee.Tool.EncodeTool.HtmlEncode(txtContact.Text);
        string Telephone = SnSee.Tool.EncodeTool.HtmlEncode(txtTelephone.Text);
        string Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        bool _Return = true;

        if (string.IsNullOrEmpty(Title) || !SalesClassID.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未选择所属分类或未填写标题！");
            return;
        }

        SalesBaseBean _SalesBaseBean = new SalesBaseBean();
        _SalesBaseBean.SalesClassID = SalesClassID;
        _SalesBaseBean.Title = Title;
        _SalesBaseBean.Address = Address;
        _SalesBaseBean.Contact = Contact;
        _SalesBaseBean.Telephone = Telephone;
        _SalesBaseBean.Email = Email;
        _SalesBaseBean.Body = txtBody.Value;
        _SalesBaseBean.SortOrder = SortOrder;
        _SalesBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        string ReturnText = "";
        if (!SalesBaseID.HasValue)
        {//不存在数据,进行增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0301", true);
            if (!SnSee.Factory.Factory.SalesBase.Insert(_SalesBaseBean))
            {
                _Return = false;
            }
            ReturnText = "增加";
        }
        else
        {//已存在数据,进行更新
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0303", true);
            if (!SnSee.Factory.Factory.SalesBase.Update(_SalesBaseBean, SalesBaseID.Value))
            {
                _Return = false;
            }
            ReturnText = "编辑";
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，销售网络" + ReturnText + "成功！", "SalesList.aspx?EID=" + EditionID);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "销售网络" + ReturnText + "失败，请核查后重试！");
        }
    }

    /// <summary>
    /// 当前销售网络放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0302", true);
        if (SalesBaseID.HasValue)
        {
            SalesBaseBean _SalesBaseBean = new SalesBaseBean();
            _SalesBaseBean.State = 0;
            if (SnSee.Factory.Factory.SalesBase.Update(_SalesBaseBean, SalesBaseID.Value))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", "SalesList.aspx?EID=" + EditionID);
            }
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "数据错误，无法进行删除！", Request.RawUrl);
        }
    }
}