﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Sales_SalesClassSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private Guid? SalesClassID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Sales))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        } 
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0305", true);
        ActionType = Request["AC"];
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        SalesClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionItem1.NavName = "SalesClassSet";
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = SalesClassID;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value);
                if (EditionID.HasValue && SalesClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
                {
                    SetSalesClassData(EditionID.Value, SalesClassID.Value);
                }
            }
            rptList_DataBind();
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
            litTitle3.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入指定ID的版本的分类数据
    /// </summary>
    /// <param name="EditiionID">语言版本ID</param>
    /// <param name="ID">分类ID</param>
    private void SetSalesClassData(Guid EditionID, Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        SalesClassBean _SalesClassBean = (SalesClassBean)SnSee.Factory.Factory.SalesClass.Select("EditionID='{" + EditionID + "}' and ID='" + ID + "'");
        if (_SalesClassBean != null)
        {
            if (_SalesClassBean.ParentID.HasValue)
            {
                dropClass.SelectedValue = _SalesClassBean.ParentID.Value.ToString();
            }
            txtClassName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesClassBean.ClassName);
            txtClassKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SalesClassBean.ClassKey);
            dropState.SelectedValue = _SalesClassBean.State.Value.ToString();
            txtSortOrder.Text = _SalesClassBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入当前版本资讯分类列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Module.Sales.SalesClassTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        rptList.DataBind();
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        //DataTable dt = null;
        //if (SalesClassID.HasValue)
        //{
        //    dt = SnSee.Module.Sales.SalesClassTree.GetClassTreeList(null, SalesClassID.Value, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        //}
        //else
        //{
        //    dt = SnSee.Module.Sales.SalesClassTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        //}

        //dropClass.DataSource = dt;
        //dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcSalesClassID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcSalesClassID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0302", true);
                List<object> _SalesBaseBeanList = SnSee.Factory.Factory.SalesBase.SelectList(0, "SalesClassID='{" + AcSalesClassID.Value + "}'", "");
                if (_SalesBaseBeanList != null && _SalesBaseBeanList.Count > 0)
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "当前资讯分类存在相关资讯，不能进行删除，请将当前分类中的相关资讯清除掉后再执行此操作！", Request.Url.ToString());
                }

                if (SnSee.Factory.Factory.SalesClass.Delete(AcSalesClassID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            Literal litClass = (Literal)e.Item.FindControl("litClass");
            DataRowView drv = (DataRowView)e.Item.DataItem;
            if (drv != null)
            {
                if (drv["ParentID"] != null && !string.IsNullOrEmpty(drv["ParentID"].ToString()))
                {
                    SalesClassBean _SalesClassBeanLoad = (SalesClassBean)SnSee.Factory.Factory.SalesClass.Select(new Guid(drv["ParentID"].ToString()));
                    if (_SalesClassBeanLoad != null && litClass != null)
                    {
                        litClass.Text = _SalesClassBeanLoad.ClassName;
                    }
                }
            }
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        Guid? ParentID = SnSee.Tool.ConvertTool.GetGuid(dropClass.SelectedValue);
        string ClassName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassName.Text);
        string ClassKey = SnSee.Tool.EncodeTool.HtmlEncode(txtClassKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (string.IsNullOrEmpty(ClassName) || string.IsNullOrEmpty(ClassKey))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入语言版本名称或版本标识！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "ClassKey='" + ClassKey + "'";
        if (SalesClassID.HasValue)
        {
            Where += " And ClassKey<>'" + ClassKey + "'";
        }
        SalesClassBean _SalesClassBeanCheck = (SalesClassBean)SnSee.Factory.Factory.SalesClass.Select(Where);
        if (_SalesClassBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的版本标识，请更换另一个后重试操作！");
            return;
        }

        SalesClassBean _SalesClassBean = new SalesClassBean();
        _SalesClassBean.EditionID = EditionID;
        _SalesClassBean.ClassName = ClassName;
        _SalesClassBean.ClassKey = ClassKey;
        _SalesClassBean.State = State;
        _SalesClassBean.SortOrder = SortOrder;
        _SalesClassBean.Depth = 1;
        if (ParentID.HasValue)
        {
            _SalesClassBean.DepthPath = ParentID.Value.ToString();
            SalesClassBean _SalesClassBeanParent = (SalesClassBean)SnSee.Factory.Factory.SalesClass.Select(ParentID.Value);
            if (_SalesClassBeanParent != null)
            {
                _SalesClassBean.ParentID = ParentID;
                _SalesClassBean.Depth = _SalesClassBeanParent.Depth + 1;
                if (string.IsNullOrEmpty(_SalesClassBeanParent.DepthPath))
                {
                    _SalesClassBean.DepthPath = ParentID.Value.ToString();
                }
                else
                {
                    _SalesClassBean.DepthPath = _SalesClassBeanParent.DepthPath + "," + ParentID.Value;
                }
            }
        }

        bool _Return = false;
        if (SalesClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0303", true);
            _Return = SnSee.Factory.Factory.SalesClass.Update(_SalesClassBean, SalesClassID.Value);
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0301", true);
            _Return = SnSee.Factory.Factory.SalesClass.Insert(_SalesClassBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}