﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Sales_SalesList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;
    private Guid? SalesClassID;
    private string Keyword;
    private string Where;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Sales))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0305", true);
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        SalesClassID = SnSee.Tool.ConvertTool.GetGuid(Request["CID"]);
        Keyword = Request.QueryString["Key"];

        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        Where = "SalesBase.[State]=1 And SalesClass.[EditionID]='{" + EditionID + "}'";
        if (SalesClassID.HasValue)
        {
            Where += " And (SalesClass.ID='{" + SalesClassID.Value + "}' Or SalesClass.[DepthPath] Like '%" + SalesClassID.Value + "%') ";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.EncodeTool.HtmlEncode(Keyword);
            Where += " And SalesBase.[Title] Like '%" + Keyword + "%'";
        }

        EditionItem1.NavName = "SalesList";
        EditionItem1.EditionID = EditionID;

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                LoadEdition(EditionID.Value);
                dropClass_DataBind(EditionID.Value);
            }

            if (SalesClassID.HasValue)
            {
                dropClass.SelectedValue = SalesClassID.Value.ToString();
            }
            if (!string.IsNullOrEmpty(Keyword))
            {
                txtKeyWord.Text = Keyword;
            }
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By SalesBase.SortOrder Asc, SalesBase.CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void LoadEdition(Guid EditiionID)
    {
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(EditiionID);
        if (_EditionBean != null)
        {
            litTitle.Text = _EditionBean.EditionName;
        }
    }

    /// <summary>
    /// 载入当前语言版本分类数据
    /// </summary>
    private void dropClass_DataBind(Guid EditionID)
    {
        dropClass.DataSource = SnSee.Module.Sales.SalesClassTree.GetClassTreeList(null, "State=1 And EditionID='{" + EditionID + "}'", "Order by SortOrder asc, CreateTime Desc");
        dropClass.DataBind();

        dropClass.Items.Insert(0, new ListItem("根级", ""));
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.SalesBase.GetSalesListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }


    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? SalesBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!SalesBaseID.HasValue && string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        switch (e.CommandName.ToLower())
        {
            case "delete_command"://放入回收站 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0302", true);
                SalesBaseBean _SalesBaseBean = new SalesBaseBean();
                _SalesBaseBean.State = 0;
                if (SnSee.Factory.Factory.SalesBase.Update(_SalesBaseBean, SalesBaseID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，销售网络放入回收站成功！", Request.RawUrl);
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "销售网络放入回收站失败，请重试！", Request.RawUrl);
                }
                break;
        }
    }

    /// <summary>
    /// 搜索销售网络
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("SalesList.aspx?EID=" + EditionID + "&CID=" + dropClass.SelectedValue + "&Key=" + txtKeyWord.Text);
    }

    /// <summary>
    /// 批量放入回收站
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllDel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0302", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _SalesBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _SalesBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得销售网络ID

            if (chkSelect.Checked && _SalesBaseID.HasValue)
            {
                SalesBaseBean _SalesBaseBean = new SalesBaseBean();
                _SalesBaseBean.State = 0;
                if (!SnSee.Factory.Factory.SalesBase.Update(_SalesBaseBean, _SalesBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选销售网络放入回收站成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选销售网络放入回收站存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}