﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_Service_ServiceList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private string Where;
    private string UserName = "";
    private string ProductName = "";
    private string ProductModel = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Service))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0505", true);
        UserName = Request.QueryString["UserName"];
        ProductName = Request.QueryString["ProductName"];
        ProductModel = Request.QueryString["ProductModel"];

        Where = "1=1 ";
        if (!string.IsNullOrEmpty(UserName))
        {
            Where += " And [UserName] Like '%" + UserName + "%'";
        }
        if (!string.IsNullOrEmpty(ProductName))
        {
            Where += " And [ProductName] Like '%" + ProductName + "%'";
        }
        if (!string.IsNullOrEmpty(ProductModel))
        {
            Where += " And [ProductModel] Like '%" + ProductModel + "%'";
        }

        if (!IsPostBack)
        {
            txtUserName.Text = UserName;
            txtProductName.Text = ProductName;
            txtProductModel.Text = ProductModel;

            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.ServiceOrder.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("ServiceList.aspx?UserName=" + txtUserName.Text + "&ProductName=" + txtProductName.Text + "&ProductModel=" + txtProductModel.Text);
    }
}