﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_Service_ServiceView : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? ServiceOrderID;
    protected string UserName;
    protected Guid? UserBaseID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.Service))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0504", true);
        ServiceOrderID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);

        if (!IsPostBack)
        {
            SetProductOrderDateYear();
            if (ServiceOrderID.HasValue)
            {
                GetServiceOrder(ServiceOrderID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void SetProductOrderDateYear()
    {
        int StartYear = 2009;
        int EndYear = DateTime.Now.Year;

        for (int i = StartYear; i <= EndYear; i++)
        {
            dropProductOrderDateYear.Items.Add(new ListItem(i.ToString(), i.ToString()));
        }
    }

    /// <summary>
    /// 取得加盟信息
    /// </summary>
    /// <param name="ID">加盟信息ID</param>
    private void GetServiceOrder(Guid ID)
    {
        ServiceOrderBean _ServiceOrderBean = (ServiceOrderBean)SnSee.Factory.Factory.ServiceOrder.Select(ID);
        if (_ServiceOrderBean != null)
        {
            txtUserName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.UserName);
            if (_ServiceOrderBean.Gender.HasValue)
            {
                rbtnGender.SelectedValue = _ServiceOrderBean.Gender.Value.ToString();
            }
            txtAge.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Age);
            txtTelephone.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Telephone);
            txtMobile.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Mobile);
            txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Fax);
            txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Address);
            txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.Email);
            txtPostalCode.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.PostalCode);
            txtProductName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductName);
            txtProductModel.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductModel);
            txtProductColor.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductColor);
            txtProductSize.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductSize);
            if (_ServiceOrderBean.ProductQuantity.HasValue)
            {
                txtProductQuantity.Text = _ServiceOrderBean.ProductQuantity.ToString();
            }
            if (_ServiceOrderBean.ProductOrderDate.HasValue)
            {
                dropProductOrderDateYear.SelectedValue = _ServiceOrderBean.ProductOrderDate.Value.Year.ToString();
                dropProductOrderDateMonth.SelectedValue = _ServiceOrderBean.ProductOrderDate.Value.Month.ToString();
                dropProductOrderDateDay.SelectedValue = _ServiceOrderBean.ProductOrderDate.Value.Day.ToString();
            }
            txtProductSeller.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductSeller);
            txtProductOrder.Text = SnSee.Tool.EncodeTool.HtmlDecode(_ServiceOrderBean.ProductOrder);

            if (_ServiceOrderBean.UserBaseID.HasValue)
            {
                SnSee.Bean.UserBaseBean _UserBaseBean = (SnSee.Bean.UserBaseBean)SnSee.Factory.Factory.UserBase.Select(_ServiceOrderBean.UserBaseID.Value);
                if (_UserBaseBean != null)
                {
                    UserName = _UserBaseBean.UserName;
                    UserBaseID = _UserBaseBean.ID;
                }
            }
        }
    }

    protected void btnPost_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "A0503", true);
        int? ProductQuantity = SnSee.Tool.ConvertTool.GetInt32(txtProductQuantity.Text);
        DateTime? ProductOrderDate = SnSee.Tool.ConvertTool.GetDateTime(dropProductOrderDateYear.SelectedValue + "-" + dropProductOrderDateMonth.SelectedValue + "-" + dropProductOrderDateDay.SelectedValue);

        if (!ProductQuantity.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品数量只能输入数字，请检查后重试！");
            return;
        }
        if (!ProductOrderDate.HasValue)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "产品购买日期未选填，请检查后重试！");
            return;
        }

        ServiceOrderBean _ServiceOrderBean = new ServiceOrderBean();
        _ServiceOrderBean.UserName = SnSee.Tool.EncodeTool.HtmlEncode(txtUserName.Text);
        _ServiceOrderBean.Gender = SnSee.Tool.ConvertTool.GetInt32(rbtnGender.SelectedValue);
        _ServiceOrderBean.Age = SnSee.Tool.EncodeTool.HtmlEncode(txtAge.Text);
        _ServiceOrderBean.Telephone = SnSee.Tool.EncodeTool.HtmlEncode(txtTelephone.Text);
        _ServiceOrderBean.Mobile = SnSee.Tool.EncodeTool.HtmlEncode(txtMobile.Text);
        _ServiceOrderBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
        _ServiceOrderBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        _ServiceOrderBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        _ServiceOrderBean.PostalCode = SnSee.Tool.EncodeTool.HtmlEncode(txtPostalCode.Text);
        _ServiceOrderBean.ProductName = SnSee.Tool.EncodeTool.HtmlEncode(txtProductName.Text);
        _ServiceOrderBean.ProductModel = SnSee.Tool.EncodeTool.HtmlEncode(txtProductModel.Text);
        _ServiceOrderBean.ProductColor = SnSee.Tool.EncodeTool.HtmlEncode(txtProductColor.Text);
        _ServiceOrderBean.ProductSize = SnSee.Tool.EncodeTool.HtmlEncode(txtProductSize.Text);
        _ServiceOrderBean.ProductQuantity = ProductQuantity;
        _ServiceOrderBean.ProductOrderDate = ProductOrderDate;
        _ServiceOrderBean.ProductSeller = SnSee.Tool.EncodeTool.HtmlEncode(txtProductSeller.Text);
        _ServiceOrderBean.ProductOrder = SnSee.Tool.EncodeTool.HtmlEncode(txtProductOrder.Text);

        if (SnSee.Factory.Factory.ServiceOrder.Update(_ServiceOrderBean, ServiceOrderID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
        }
    }
}