﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.ComponentModel;
using System.Xml.XPath;
using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_SystemConfig_AdminMenuSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? AdminMenuID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }
        ActionType = Request["AC"];

        AdminMenuID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!IsPostBack)
        {
            dropMenu_DataBind();
            dropManage_DataBind();
            if (AdminMenuID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
            {
                GetAdminMenuData(AdminMenuID.Value);
            }
            rptList_DataBind();
        }
    }

    /// <summary>
    /// 载入指定ID的菜单数据
    /// </summary>
    /// <param name="ID">菜单ID</param>
    private void GetAdminMenuData(Guid ID)
    {
        lbtnAdd.Text = "编辑";
        AdminMenuBean _AdminMenuBean = (AdminMenuBean)SnSee.Factory.Factory.AdminMenu.Select(ID);
        if (_AdminMenuBean != null)
        {
            if (_AdminMenuBean.ParentID.HasValue)
            {
                dropMenu.SelectedValue = _AdminMenuBean.ParentID.Value.ToString();
            }
            if (_AdminMenuBean.AdminManageID.HasValue)
            {
                dropManage.SelectedValue = _AdminMenuBean.AdminManageID.Value.ToString();
            }
            txtMenuName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_AdminMenuBean.MenuName);
            txtMenuLink.Text = SnSee.Tool.EncodeTool.HtmlDecode(_AdminMenuBean.MenuLink);
            dropState.SelectedValue = _AdminMenuBean.State.Value.ToString();
            txtSortOrder.Text = _AdminMenuBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入当前菜单列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Module.Admin.AdminMenuTree.GetClassTreeList(null, "", "Order by SortOrder asc");
        rptList.DataBind();
    }

    /// <summary>
    /// 载入菜单数据
    /// </summary>
    private void dropMenu_DataBind()
    {
        DataTable dt = null;
        if (AdminMenuID.HasValue)
        {
            dt = SnSee.Module.Admin.AdminMenuTree.GetClassTreeList(null, AdminMenuID.Value, "", "Order by SortOrder asc");
        }
        else
        {
            dt = SnSee.Module.Admin.AdminMenuTree.GetClassTreeList(null, "", "Order by SortOrder asc");
        }

        dropMenu.DataSource = dt;
        dropMenu.DataBind();

        dropMenu.Items.Insert(0, new ListItem("根级", ""));
    }

    /// <summary>
    /// 载入管理权限数据
    /// </summary>
    private void dropManage_DataBind()
    {
        dropManage.DataSource = SnSee.Module.Admin.AdminManageTree.GetClassTreeList(null, "", "Order by CreateTime asc");
        dropManage.DataBind();

        dropManage.Items.Insert(0, new ListItem("根级", ""));
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcAdminMenuID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcAdminMenuID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除
                if (SnSee.Factory.Factory.AdminMenu.Delete(AcAdminMenuID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    //protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    //{
    //if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
    //{
    //    Literal litManage = (Literal)e.Item.FindControl("litManage");
    //    XPathNavigator _XPathNavigator = ((IXPathNavigable)e.Item.DataItem).CreateNavigator();
    //    if (_XPathNavigator != null)
    //    {
    //        if (!string.IsNullOrEmpty(_XPathNavigator.GetAttribute("AdminManageID", _XPathNavigator.NamespaceURI)))
    //        {
    //            AdminManageBean _AdminManageBeanLoad = (AdminManageBean)SnSee.Factory.Factory.AdminManage.Select(new Guid(_XPathNavigator.GetAttribute("AdminManageID", _XPathNavigator.NamespaceURI)));
    //            if (_AdminManageBeanLoad != null && litManage != null)
    //            {
    //                litManage.Text = _AdminManageBeanLoad.ManageName;
    //            }
    //        }
    //    }
    //}
    //}

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        Guid? ParentID = SnSee.Tool.ConvertTool.GetGuid(dropMenu.SelectedValue);
        Guid? AdminManageID = SnSee.Tool.ConvertTool.GetGuid(dropManage.SelectedValue);
        string MenuName = SnSee.Tool.EncodeTool.HtmlEncode(txtMenuName.Text);
        string MenuLink = SnSee.Tool.EncodeTool.HtmlEncode(txtMenuLink.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (string.IsNullOrEmpty(MenuName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入菜单名称！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        AdminMenuBean _AdminMenuBean = new AdminMenuBean();
        _AdminMenuBean.MenuName = MenuName;
        _AdminMenuBean.MenuLink = MenuLink;
        _AdminMenuBean.State = State;
        _AdminMenuBean.SortOrder = SortOrder;
        _AdminMenuBean.ParentID = ParentID;
        _AdminMenuBean.AdminManageID = AdminManageID;

        bool _Return = false;
        if (AdminMenuID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            _Return = SnSee.Factory.Factory.AdminMenu.Update(_AdminMenuBean, AdminMenuID.Value);
        }
        else
        {//增加
            _Return = SnSee.Factory.Factory.AdminMenu.Insert(_AdminMenuBean);
        }

        if (_Return)
        {
            SnSee.Module.Admin.AdminMenuTree.SetXmlClassTree(null, null, "1=1", "Order By SortOrder Asc");
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}