﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_SystemConfig_Edition : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Config.WebConfig.EditionAdmin)
        {
            SnSee.Module.Admin.Message.AdminErrorTip("尚未开启语言版本管理功能，请先在系统参数设置中进行设置！<br /><br /><a href='SystemConfig/SystemConfig.aspx'>点击这里进行系统参数设置</a>", "../");
        }
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        if (EditionID.HasValue)
        {
            if (!IsPostBack)
            {
                SetEditionData(EditionID.Value);
            }
        }
        rptList_DataBind();
    }

    /// <summary>
    /// 载入指定ID的版本数据
    /// </summary>
    /// <param name="ID"></param>
    private void SetEditionData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        EditionBean _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select(ID);
        if (_EditionBean != null)
        {
            txtEditionName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_EditionBean.EditionName);
            txtEditionKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_EditionBean.EditionKey);
            dropState.SelectedValue = _EditionBean.State.Value.ToString();
            txtSortOrder.Text = _EditionBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入版本列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.Edition.SelectList(0, "", "Order By SortOrder Asc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcEditionID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcEditionID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除
                if (SnSee.Factory.Factory.Edition.Delete(AcEditionID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string EditionName = SnSee.Tool.EncodeTool.HtmlEncode(txtEditionName.Text);
        string EditionKey = SnSee.Tool.EncodeTool.HtmlEncode(txtEditionKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (string.IsNullOrEmpty(EditionName) || string.IsNullOrEmpty(EditionKey))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入语言版本名称或版本标识！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "EditionKey='" + EditionKey + "'";
        if (EditionID.HasValue)
        {
            Where += " And EditionKey<>'" + EditionKey + "'";
        }
        EditionBean _EditionBeanCheck = (EditionBean)SnSee.Factory.Factory.Edition.Select(Where);
        if (_EditionBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的版本标识，请更换另一个后重试操作！");
            return;
        }

        EditionBean _EditionBean = new EditionBean();
        _EditionBean.EditionName = EditionName;
        _EditionBean.EditionKey = EditionKey;
        _EditionBean.State = State;
        _EditionBean.SortOrder = SortOrder;

        bool _Return = false;
        if (EditionID.HasValue)
        {//编辑 
            _Return = SnSee.Factory.Factory.Edition.Update(_EditionBean, EditionID.Value);
        }
        else
        {//增加
            _Return = SnSee.Factory.Factory.Edition.Insert(_EditionBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}