﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using SnSee.Config;
using SnSee.Bean;

public partial class Admin_SystemConfig_EmailPasswordSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            SnSee.Module.Admin.Message.AdminErrorTip("您目前无权限访问当前页，请联系网站管理员！", "../");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "Z010204", true, "ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");

        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }
        EditionItem1.NavName = "EmailPasswordSet";
        EditionItem1.EditionID = EditionID;
        EditionItem1.NavDir = "SystemConfig";

        if (!IsPostBack)
        {
            if (EditionID.HasValue)
            {
                GetEmail(EditionID.Value);
            }
        }
    }

    /// <summary>
    /// 取得邮件配置内容
    /// </summary>
    /// <param name="EditionID">语言版本ID</param>
    private void GetEmail(Guid EditionID)
    {
        EmailClassBean _EmailClassBean = (EmailClassBean)SnSee.Factory.Factory.EmailClass.Select("ClassKey='" + SnSee.Config.EmailClassKey.UserGetPassword.ToString() + "'");
        if (_EmailClassBean != null)
        {
            EmailBaseBean _EmailBaseBean = (EmailBaseBean)SnSee.Factory.Factory.EmailBase.Select("EmailClassID='{" + _EmailClassBean.ID.Value + "}' And EditionID='{" + EditionID + "}'");
            if (_EmailBaseBean != null)
            {
                txtTitle.Text = _EmailBaseBean.Title;
                txtBody.Value = _EmailBaseBean.Body;
            }
        }
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        string Title = txtTitle.Text;
        string Body = txtBody.Value;
        if (string.IsNullOrEmpty(Title))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入邮件标题！");
            return;
        }
        if (string.IsNullOrEmpty(Body))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入邮件模板内容！");
            return;
        }

        bool _Return = false;
        EmailClassBean _EmailClassBean = (EmailClassBean)SnSee.Factory.Factory.EmailClass.Select("ClassKey='" + SnSee.Config.EmailClassKey.UserGetPassword.ToString() + "'");
        if (_EmailClassBean != null)
        {
            EmailBaseBean _EmailBaseBeanCheck = (EmailBaseBean)SnSee.Factory.Factory.EmailBase.Select("EmailClassID='{" + _EmailClassBean.ID.Value + "}' And EditionID='{" + EditionID + "}'");
            EmailBaseBean _EmailBaseBean = new EmailBaseBean();
            _EmailBaseBean.Title = Title;
            _EmailBaseBean.Body = Body;
            _EmailBaseBean.EmailClassID = _EmailClassBean.ID;
            _EmailBaseBean.EditionID = EditionID;
            _EmailBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

            if (_EmailBaseBeanCheck == null)
            {
                _Return = SnSee.Factory.Factory.EmailBase.Insert(_EmailBaseBean);
            }
            else
            {
                _Return = SnSee.Factory.Factory.EmailBase.Update(_EmailBaseBean, _EmailBaseBeanCheck.ID.Value);
            }
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}
