﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_SystemConfig_InfoClassSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? InfoClassID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.CompanyInfo))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }
        ActionType = Request["AC"];

        InfoClassID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!IsPostBack)
        {
            if (InfoClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
            {
                SetInfoClassData(InfoClassID.Value);
            }
            rptList_DataBind();
        }

    }

    /// <summary>
    /// 载入指定ID的数据
    /// </summary>
    /// <param name="ID">分类ID</param>
    private void SetInfoClassData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        InfoClassBean _InfoClassBean = (InfoClassBean)SnSee.Factory.Factory.InfoClass.Select("ID='{" + ID + "}'");
        if (_InfoClassBean != null)
        {
            txtClassName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_InfoClassBean.ClassName);
            txtClassKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_InfoClassBean.ClassKey);
            dropState.SelectedValue = _InfoClassBean.State.Value.ToString();
        }
    }

    /// <summary>
    /// 载入列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.InfoClass.SelectList(0, "", "Order By CreateTime Desc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcInfoClassID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcInfoClassID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除
                //List<object> _InfoBeanList = SnSee.Factory.Factory.InfoBase.SelectList(0, "InfoClassID='{" + AcInfoClassID + "}'", "");
                //if (_InfoBeanList != null && _InfoBeanList.Count > 0)
                //{
                // SnSee.Tool.MessageTool.MessageBox(this.Page, "当前信息类别存在相关数据，不能进行删除，请将当前信息类别的相关内容清除掉后再执行此操作！", Request.Url.ToString());
                //}

                if (SnSee.Factory.Factory.InfoClass.Delete(AcInfoClassID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string ClassName = SnSee.Tool.EncodeTool.HtmlEncode(txtClassName.Text);
        string ClassKey = SnSee.Tool.EncodeTool.HtmlEncode(txtClassKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        if (!State.HasValue)
        {
            State = 1;
        }

        string Where = "ClassKey='" + ClassKey + "'";
        if (InfoClassID.HasValue)
        {
            Where += " And ClassKey<>'" + ClassKey + "'";
        }
        InfoClassBean _InfoClassBeanCheck = (InfoClassBean)SnSee.Factory.Factory.InfoClass.Select(Where);
        if (_InfoClassBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的标识，请更换另一个后重试操作！");
            return;
        }

        InfoClassBean _InfoClassBean = new InfoClassBean();
        _InfoClassBean.ClassName = ClassName;
        _InfoClassBean.ClassKey = ClassKey;
        _InfoClassBean.State = State;

        bool _Return = false;
        if (InfoClassID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            _Return = SnSee.Factory.Factory.InfoClass.Update(_InfoClassBean, InfoClassID.Value);
        }
        else
        {//增加
            _Return = SnSee.Factory.Factory.InfoClass.Insert(_InfoClassBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}