﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

using SnSee.Config;
using SnSee.Bean;

public partial class Admin_SystemConfig_ManagePassword : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    XmlDocument _XmlDocument;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }
        _XmlDocument = SnSee.Tool.XmlTool.GetXmlDocument(Server.MapPath(SnSee.Config.WebConfig.ConfigPath));
        if (!IsPostBack)
        {
            GetManage();
        }
    }

    /// <summary>
    /// 载入
    /// </summary>
    private void GetManage()
    {
        txtManageName.Text = SnSee.Tool.XmlTool.GetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(SnSee.Tool.XmlTool.GetXmlNodeByTagName(SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config"), "Manage"), "System"), "Name");    //管理员名称
    }

    protected void lbtnSave_Click(object sender, EventArgs e)
    {
        //SnSee.Tool.MessageTool.MessageBox(this.Page, "为了演示时，其它查看演示网友能进入后台，这里不允许修改用户及密码，请大家理解一下！", Request.RawUrl);
        //return;
        bool IsSave = true;
        XmlNode xnManage;
        XmlNode xnRoot = SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config");
        if (xnRoot != null)
        {
            xnManage = SnSee.Tool.XmlTool.GetXmlNodeByTagName(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Manage"), "System");

            string ManageName = txtManageName.Text;
            string ManagePassword = txtManagePassword.Text;

            if (string.IsNullOrEmpty(ManageName))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "管理员名称没有填写！", Request.RawUrl);
            }

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(xnManage, "Name", ManageName))
            {
                IsSave = false;
            }

            if (!string.IsNullOrEmpty(ManagePassword))
            {
                ManagePassword = SnSee.Module.Admin.Admin.SetAdminPassword(ManagePassword);
                if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(xnManage, "Password", ManagePassword))
                {
                    IsSave = false;
                }
            }
        }

        if (IsSave)
        {
            _XmlDocument.Save(Server.MapPath(SnSee.Config.WebConfig.ConfigPath)); SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，资料保存成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "当前资料保存时存在错误，请核实后重试！", Request.RawUrl);
        }
    }
}
