﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

using SnSee.Config;
using SnSee.Bean;

public partial class Admin_SystemConfig_SystemConfig : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    XmlDocument _XmlDocument;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=您目前无权限访问当前页，请联系网站管理员！");
        }
        _XmlDocument = SnSee.Tool.XmlTool.GetXmlDocument(Server.MapPath(SnSee.Config.WebConfig.ConfigPath));

        if (!IsPostBack)
        {
            GetBaseInfoConfig();
            GetBaseConfig();
            GetModuleConfig();
            GetModuleAttributeConfig();
        }
    }

    /// <summary>
    /// 载入基本信息设置
    /// </summary>
    private void GetBaseInfoConfig()
    {
        txtSiteTitle.Text = SnSee.Config.WebConfig.SiteTitle;
        txtSiteUrl.Text = SnSee.Config.WebConfig.SiteUrl;
        txtSiteSubhead.Text = SnSee.Config.WebConfig.SiteSubhead;
        txtKeywords.Text = SnSee.Config.PageConfig.Keywords;
        txtDescription.Text = SnSee.Config.PageConfig.Description;
    }

    /// <summary>
    /// 载入基本参数设置
    /// </summary>
    private void GetBaseConfig()
    {
        //系统增加语言版本功能
        chkIsEditionAdmin.Checked = SnSee.Config.WebConfig.EditionAdmin;

        txtUploadFilePath.Text = SnSee.Config.WebConfig.UploadFilePath;    //上传文件存放根路径
        txtUploadFileType.Text = SnSee.Config.WebConfig.UploadFileType;    //上传文件允许文件类型

        //是否输出系统异常信息
        chkIsExceptionThrow.Checked = SnSee.Config.ExceptionConfig.ExceptionThrow;

        //是否写异常信息日志
        chkIsExceptionThrowWriteLog.Checked = SnSee.Config.ExceptionConfig.ExceptionThrowWriteLog;

        //是否显示系统升级提示
        chkIsViewVersion.Checked = SnSee.Config.WebConfig.ViewSystemVersionUpdate;

        //是否显示系统公告
        chkIsViewSystemBulletin.Checked = SnSee.Config.WebConfig.ViewSystemBulletin;

        //是否显示管理页面页脚说明
        chkIsViewAdminPageExplain.Checked = SnSee.Config.WebConfig.ViewAdminPageExplain;

        txtEmailServerHost.Text = SnSee.Config.WebConfig.EmailServerHost;
        txtEmailName.Text = SnSee.Config.WebConfig.EmailName;

        txtSystemLoginTime.Text = SnSee.Config.ManageConfig.SystemLoginTime.ToString();
        txtAdminLoginTime.Text = SnSee.Config.ManageConfig.AdminLoginTime.ToString();
    }

    /// <summary>
    /// 载入栏目模块设置
    /// </summary>
    private void GetModuleConfig()
    {
        chkIsCompanyInfo.Checked = SnSee.Config.ModuleConfig.SystemModuleCompanyInfoOpen;
        chkIsFeedback.Checked = SnSee.Config.ModuleConfig.SystemModuleFeedbackOpen;
        chkIsSales.Checked = SnSee.Config.ModuleConfig.SystemModuleSalesOpen;
        chkIsJoin.Checked = SnSee.Config.ModuleConfig.SystemModuleJoinOpen;
        chkIsService.Checked = SnSee.Config.ModuleConfig.SystemModuleServiceOpen;
        chkIsProduct.Checked = SnSee.Config.ModuleConfig.SystemModuleProductOpen;
        chkIsArticle.Checked = SnSee.Config.ModuleConfig.SystemModuleArticleOpen;
        chkIsUser.Checked = SnSee.Config.ModuleConfig.SystemModuleUserOpen;
        chkIsOrder.Checked = SnSee.Config.ModuleConfig.SystemModuleOrderOpen;
        chkIsLink.Checked = SnSee.Config.ModuleConfig.SystemModuleLinkOpen;
    }

    /// <summary>
    /// 载入栏目模块参数设置
    /// </summary>
    private void GetModuleAttributeConfig()
    {
        #region 产品
        chkIsPriceOpen.Checked = SnSee.Config.ProductConfig.PriceOpen;
        chkIsAttributeOpen.Checked = SnSee.Config.ProductConfig.AttributeOpen;
        chkIsProductOtherPicOpen.Checked = SnSee.Config.ProductConfig.OtherPicOpen;

        chkIsProductPicPath1.Checked = SnSee.Config.ProductConfig.ProductPicPath1Open;
        chkIsProductPicPath2.Checked = SnSee.Config.ProductConfig.ProductPicPath2Open;
        chkIsProductPicPath3.Checked = SnSee.Config.ProductConfig.ProductPicPath3Open;
        chkIsMakeProductPicPath1.Checked = SnSee.Config.ProductConfig.MakeProductPicPath1Open;
        chkIsMakeProductPicPath2.Checked = SnSee.Config.ProductConfig.MakeProductPicPath2Open;
        chkIsMakeProductPicPath3.Checked = SnSee.Config.ProductConfig.MakeProductPicPath3Open;

        txtProductPicPath1Width.Text = SnSee.Config.ProductConfig.ProductPicPath1Width.ToString();
        txtProductPicPath2Width.Text = SnSee.Config.ProductConfig.ProductPicPath2Width.ToString();
        txtProductPicPath3Width.Text = SnSee.Config.ProductConfig.ProductPicPath3Width.ToString();
        txtProductPicPath1Height.Text = SnSee.Config.ProductConfig.ProductPicPath1Height.ToString();
        txtProductPicPath2Height.Text = SnSee.Config.ProductConfig.ProductPicPath2Height.ToString();
        txtProductPicPath3Height.Text = SnSee.Config.ProductConfig.ProductPicPath3Height.ToString();

        chkIsMustProductPicPath1.Checked = SnSee.Config.ProductConfig.MustProductPicPath1;
        chkIsMustProductPicPath2.Checked = SnSee.Config.ProductConfig.MustProductPicPath2;
        chkIsMustProductPicPath3.Checked = SnSee.Config.ProductConfig.MustProductPicPath3;

        chkIsProductOtherPicPath1.Checked = SnSee.Config.ProductConfig.ProductOtherPicPath1Open;
        chkIsProductOtherPicPath2.Checked = SnSee.Config.ProductConfig.ProductOtherPicPath2Open;
        chkIsProductOtherPicPath3.Checked = SnSee.Config.ProductConfig.ProductOtherPicPath3Open;
        chkIsMakeProductOtherPicPath1.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath1Open;
        chkIsMakeProductOtherPicPath2.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath2Open;
        chkIsMakeProductOtherPicPath3.Checked = SnSee.Config.ProductConfig.MakeProductOtherPicPath3Open;

        txtProductOtherPicPath1Width.Text = SnSee.Config.ProductConfig.ProductOtherPicPath1Width.ToString();
        txtProductOtherPicPath2Width.Text = SnSee.Config.ProductConfig.ProductOtherPicPath2Width.ToString();
        txtProductOtherPicPath3Width.Text = SnSee.Config.ProductConfig.ProductOtherPicPath3Width.ToString();
        txtProductOtherPicPath1Height.Text = SnSee.Config.ProductConfig.ProductOtherPicPath1Height.ToString();
        txtProductOtherPicPath2Height.Text = SnSee.Config.ProductConfig.ProductOtherPicPath2Height.ToString();
        txtProductOtherPicPath3Height.Text = SnSee.Config.ProductConfig.ProductOtherPicPath3Height.ToString();

        chkIsMustProductOtherPicPath1.Checked = SnSee.Config.ProductConfig.MustProductOtherPicPath1;
        chkIsMustProductOtherPicPath2.Checked = SnSee.Config.ProductConfig.MustProductOtherPicPath2;
        chkIsMustProductOtherPicPath3.Checked = SnSee.Config.ProductConfig.MustProductOtherPicPath3;

        chkIsProductIntro.Checked = SnSee.Config.ProductConfig.IntroOpen;
        #endregion

        #region 资讯
        bool TitleImageOpen = SnSee.Config.ArticleConfig.TitleImageOpen;
        chkIsArticleTitleImageOpen.Checked = TitleImageOpen;
        if (TitleImageOpen)
        {
            bool TitleImageMake = SnSee.Config.ArticleConfig.TitleImageMake;
            chkIsArticleTitleImageMake.Checked = TitleImageMake;
            if (!TitleImageMake)
            {
                boxArticleTitleImageMakeSize.Attributes.Add("style", "display: none;");
            }
            txtArticleTitleImageMakeWidth.Text = SnSee.Config.ArticleConfig.TitleImageWidth.ToString();
            txtArticleTitleImageMakeHeight.Text = SnSee.Config.ArticleConfig.TitleImageHeight.ToString();
            chkIsArticleTitleImageMust.Checked = SnSee.Config.ArticleConfig.TitleImageMust;
        }
        else
        {
            boxIsArticleTitleImageMake.Attributes.Add("style", "display: none;");
        }
        #endregion

        #region 邮件
        chkIsPasswordEmailOpen.Checked = SnSee.Config.EmailConfig.PasswordOpen;
        chkIsPasswordEmailHtml.Checked = SnSee.Config.EmailConfig.PasswordIsHtml;
        #endregion

        #region 信息反馈
        chkIsFeedbackPostLogin.Checked = SnSee.Config.FeedbackConfig.LoginPost;
        #endregion
    }

    /// <summary>
    /// 切换到基本信息设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnBaseInfoSet_Click(object sender, EventArgs e)
    {
        SetItemStyle();
        pnlBaseInfoConfig.Visible = true;

        itemBaseInfoConfig.Attributes.Remove("class");
        itemBaseInfoConfig.Attributes.Add("class", "item_list_cell_ac");
    }

    /// <summary>
    /// 切换到基本参数设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnBaseSet_Click(object sender, EventArgs e)
    {
        SetItemStyle();
        pnlBaseConfig.Visible = true;
        itemBaseConfig.Attributes.Remove("class");
        itemBaseConfig.Attributes.Add("class", "item_list_cell_ac");
    }

    /// <summary>
    /// 切换到栏目模块设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnModuleConfig_Click(object sender, EventArgs e)
    {
        SetItemStyle();
        pnlModuleConfig.Visible = true;
        itemModuleConfig.Attributes.Remove("class");
        itemModuleConfig.Attributes.Add("class", "item_list_cell_ac");
    }

    /// <summary>
    /// 切换到栏目模块参数设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnModuleAttributeConfig_Click(object sender, EventArgs e)
    {
        SetItemStyle();
        pnlModuleAttributeConfig.Visible = true;
        itemModuleAttributeConfig.Attributes.Remove("class");
        itemModuleAttributeConfig.Attributes.Add("class", "item_list_cell_ac");
    }

    /// <summary>
    /// 设置卡项样式
    /// </summary>
    private void SetItemStyle()
    {
        itemBaseInfoConfig.Attributes.Remove("class");
        itemBaseInfoConfig.Attributes.Add("class", "item_list_cell");
        pnlBaseInfoConfig.Visible = false;

        itemBaseConfig.Attributes.Remove("class");
        itemBaseConfig.Attributes.Add("class", "item_list_cell");
        pnlBaseConfig.Visible = false;

        itemModuleConfig.Attributes.Remove("class");
        itemModuleConfig.Attributes.Add("class", "item_list_cell");
        pnlModuleConfig.Visible = false;

        itemModuleAttributeConfig.Attributes.Remove("class");
        itemModuleAttributeConfig.Attributes.Add("class", "item_list_cell");
        pnlModuleAttributeConfig.Visible = false;
    }

    /// <summary>
    /// 保存基本参数设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSaveBaseConfig_Click(object sender, EventArgs e)
    {
        bool IsSave = true;
        XmlNode xnBase, xnManage;
        XmlNode xnRoot = SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config");
        if (xnRoot != null)
        {
            xnBase = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Base");
            xnManage = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Manage");

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "EditionAdmin"), "Open", chkIsEditionAdmin.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "UploadFile"), "Path", txtUploadFilePath.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "UploadFile"), "Type", txtUploadFileType.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "ExceptionThrow"), "Open", chkIsExceptionThrow.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "ExceptionThrowWriteLog"), "Open", chkIsExceptionThrowWriteLog.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "SystemVersionUpdate"), "Open", chkIsViewVersion.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "SystemBulletin"), "Open", chkIsViewSystemBulletin.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "AdminPageExplain"), "Open", chkIsViewAdminPageExplain.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Email"), "Name", txtEmailName.Text))
            {
                IsSave = false;
            }
            if (!string.IsNullOrEmpty(txtEmailPassword.Text) && txtEmailPassword.Text != "******")
            {
                if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Email"), "Password", SnSee.Tool.EncodeTool.ToBase64CodeString(txtEmailPassword.Text)))
                {
                    IsSave = false;
                }
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Email"), "Server", txtEmailServerHost.Text))
            {
                IsSave = false;
            }

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnManage, "System"), "Time", txtSystemLoginTime.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnManage, "Admin"), "Time", txtAdminLoginTime.Text))
            {
                IsSave = false;
            }
        }

        if (IsSave)
        {
            _XmlDocument.Save(Server.MapPath(SnSee.Config.WebConfig.ConfigPath)); SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，当前设置成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "当前设置存在错误，请核实后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 保存基本信息设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSaveBaseInfoConfig_Click(object sender, EventArgs e)
    {
        bool IsSave = true;
        XmlNode xnBase, xnPage;
        XmlNode xnRoot = SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config");
        if (xnRoot != null)
        {
            xnBase = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Base");

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Site"), "Title", txtSiteTitle.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Site"), "Subhead", txtSiteSubhead.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnBase, "Site"), "Url", txtSiteUrl.Text))
            {
                IsSave = false;
            }

            xnPage = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Page");
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnPage, "Meta"), "Keywords", txtKeywords.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnPage, "Meta"), "Description", txtDescription.Text))
            {
                IsSave = false;
            }
        }

        if (IsSave)
        {
            _XmlDocument.Save(Server.MapPath(SnSee.Config.WebConfig.ConfigPath));
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，当前设置成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "当前设置存在错误，请核实后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 保存栏目模块设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSaveModuleConfig_Click(object sender, EventArgs e)
    {
        bool IsSave = true;
        XmlNode xnModule;
        XmlNode xnRoot = SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config");
        if (xnRoot != null)
        {
            xnModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "Module");

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "CompanyInfo"), "Open", chkIsCompanyInfo.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Feedback"), "Open", chkIsFeedback.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Sales"), "Open", chkIsSales.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Join"), "Open", chkIsJoin.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Service"), "Open", chkIsService.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Product"), "Open", chkIsProduct.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Article"), "Open", chkIsArticle.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "User"), "Open", chkIsUser.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Order"), "Open", chkIsOrder.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Link"), "Open", chkIsLink.Checked.ToString()))
            {
                IsSave = false;
            }
        }

        if (IsSave)
        {
            _XmlDocument.Save(Server.MapPath(SnSee.Config.WebConfig.ConfigPath));
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，当前设置成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "当前设置存在错误，请核实后重试！", Request.RawUrl);
        }
    }

    /// <summary>
    /// 保存栏目模块参数设置
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSaveModuleAttributeConfig_Click(object sender, EventArgs e)
    {
        bool IsSave = true;
        XmlNode xnModule;
        XmlNode xnRoot = SnSee.Tool.XmlTool.GetXmlNodeByTagName(_XmlDocument, "Config");
        if (xnRoot != null)
        {
            xnModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnRoot, "ModuleConfig");

            #region 产品
            XmlNode xnProductModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Product");
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "Price"), "Open", chkIsPriceOpen.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "Attribute"), "Open", chkIsAttributeOpen.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "OtherPic"), "Open", chkIsProductOtherPicOpen.Checked.ToString()))
            {
                IsSave = false;
            }

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath1"), "Open", chkIsProductPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath2"), "Open", chkIsProductPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath3"), "Open", chkIsProductPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath1"), "Make", chkIsMakeProductPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath2"), "Make", chkIsMakeProductPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath3"), "Make", chkIsMakeProductPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath1"), "Width", txtProductPicPath1Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath2"), "Width", txtProductPicPath2Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath3"), "Width", txtProductPicPath3Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath1"), "Height", txtProductPicPath1Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath2"), "Height", txtProductPicPath2Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath3"), "Height", txtProductPicPath3Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath1"), "Must", chkIsMustProductPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath2"), "Must", chkIsMustProductPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductPicPath3"), "Must", chkIsMustProductPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }

            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath1"), "Open", chkIsProductOtherPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath2"), "Open", chkIsProductOtherPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath3"), "Open", chkIsProductOtherPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath1"), "Make", chkIsMakeProductOtherPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath2"), "Make", chkIsMakeProductOtherPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath3"), "Make", chkIsMakeProductOtherPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath1"), "Width", txtProductOtherPicPath1Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath2"), "Width", txtProductOtherPicPath2Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath3"), "Width", txtProductOtherPicPath3Width.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath1"), "Height", txtProductOtherPicPath1Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath2"), "Height", txtProductOtherPicPath2Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath3"), "Height", txtProductOtherPicPath3Height.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath1"), "Must", chkIsMustProductOtherPicPath1.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath2"), "Must", chkIsMustProductOtherPicPath2.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductOtherPicPath3"), "Must", chkIsMustProductOtherPicPath3.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnProductModule, "ProductEdition"), "Intro", chkIsProductIntro.Checked.ToString()))
            {
                IsSave = false;
            }
            #endregion

            #region 资讯
            XmlNode xnArticleModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Article");
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnArticleModule, "TitleImage"), "Open", chkIsArticleTitleImageOpen.Checked.ToString()))
            {
                IsSave = false;
            }
            if (chkIsArticleTitleImageOpen.Checked && (string.IsNullOrEmpty(txtArticleTitleImageMakeWidth.Text) || string.IsNullOrEmpty(txtArticleTitleImageMakeHeight.Text)))
            {
                SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入资讯模块标题图片自动生成时的宽或高！");
                return;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnArticleModule, "TitleImage"), "Width", txtArticleTitleImageMakeWidth.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnArticleModule, "TitleImage"), "Height", txtArticleTitleImageMakeHeight.Text))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnArticleModule, "TitleImage"), "Make", chkIsArticleTitleImageMake.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnArticleModule, "TitleImage"), "Must", chkIsArticleTitleImageMust.Checked.ToString()))
            {
                IsSave = false;
            }
            #endregion
            #region 邮件
            XmlNode xnEmailModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Email");
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnEmailModule, "Password"), "Open", chkIsPasswordEmailOpen.Checked.ToString()))
            {
                IsSave = false;
            }
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnEmailModule, "Password"), "Html", chkIsPasswordEmailHtml.Checked.ToString()))
            {
                IsSave = false;
            }
            #endregion

            #region 信息反馈
            XmlNode xnFeedbackModule = SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnModule, "Feedback");
            if (!SnSee.Tool.XmlTool.SetXmlNodeAttributeInnerText(SnSee.Tool.XmlTool.GetXmlNodeByTagName(xnFeedbackModule, "Post"), "Login", chkIsFeedbackPostLogin.Checked.ToString()))
            {
                IsSave = false;
            }
            #endregion
        }

        if (IsSave)
        {
            _XmlDocument.Save(Server.MapPath(SnSee.Config.WebConfig.ConfigPath));
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，当前设置成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "当前设置存在错误，请核实后重试！", Request.RawUrl);
        }
    }
}
