﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_SystemConfig_SystemMenuSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? SystemMenuID;
    private string ActionType;
    private Guid? EditionID;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.IsSystemManage(_AdminBeanLogin.AdminName, _AdminBeanLogin.AdminPwd))
        {
            SnSee.Module.Admin.Message.AdminErrorTip("您目前无权限访问当前页，请联系网站管理员！", "../");
        }
        ActionType = Request["AC"];
        EditionID = SnSee.Tool.ConvertTool.GetGuid(Request["EditionID"]);
        if (!EditionID.HasValue)
        {
            EditionID = SnSee.Module.Systems.Edition.GetFirstEditionID();
        }

        SystemMenuID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);
        EditionItem1.NavName = "SystemMenuSet";
        EditionItem1.EditionID = EditionID;
        EditionItem1.ObjectID = SystemMenuID;
        EditionItem1.NavDir = "SystemConfig";

        if (!IsPostBack)
        {
            dropMenu_DataBind();
            if (SystemMenuID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
            {
                GetSystemMenuData(SystemMenuID.Value);
            }
            if (EditionID.HasValue)
            {
                rptList_DataBind(EditionID.Value);
            }
        }
    }

    /// <summary>
    /// 载入指定ID的菜单数据
    /// </summary>
    /// <param name="ID">菜单ID</param>
    private void GetSystemMenuData(Guid ID)
    {
        lbtnAdd.Text = "编辑";
        SystemMenuBean _SystemMenuBean = (SystemMenuBean)SnSee.Factory.Factory.SystemMenu.Select(ID);
        if (_SystemMenuBean != null)
        {
            if (_SystemMenuBean.ParentID.HasValue)
            {
                dropMenu.SelectedValue = _SystemMenuBean.ParentID.Value.ToString();
            }
            txtMenuName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SystemMenuBean.MenuName);
            txtMenuLink.Text = SnSee.Tool.EncodeTool.HtmlDecode(_SystemMenuBean.MenuLink);
            if (_SystemMenuBean.State.HasValue)
            {
                dropState.SelectedValue = _SystemMenuBean.State.Value.ToString();
            }
            if (_SystemMenuBean.SortOrder.HasValue)
            {
                txtSortOrder.Text = _SystemMenuBean.SortOrder.Value.ToString();
            }
        }
    }

    /// <summary>
    /// 载入当前菜单列表
    /// </summary>
    private void rptList_DataBind(Guid EditionID)
    {
        rptList.DataSource = SnSee.Module.Systems.SystemMenuTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        rptList.DataBind();
    }

    /// <summary>
    /// 载入菜单数据
    /// </summary>
    private void dropMenu_DataBind()
    {
        DataTable dt = null;
        if (SystemMenuID.HasValue)
        {
            dt = SnSee.Module.Systems.SystemMenuTree.GetClassTreeList(null, SystemMenuID.Value, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        }
        else
        {
            dt = SnSee.Module.Systems.SystemMenuTree.GetClassTreeList(null, "EditionID='{" + EditionID + "}'", "Order by SortOrder asc");
        }

        dropMenu.DataSource = dt;
        dropMenu.DataBind();

        dropMenu.Items.Insert(0, new ListItem("根级", ""));
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcSystemMenuID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcSystemMenuID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除
                if (SnSee.Factory.Factory.SystemMenu.Delete(AcSystemMenuID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        Guid? ParentID = SnSee.Tool.ConvertTool.GetGuid(dropMenu.SelectedValue);
        string MenuName = SnSee.Tool.EncodeTool.HtmlEncode(txtMenuName.Text);
        string MenuLink = SnSee.Tool.EncodeTool.HtmlEncode(txtMenuLink.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (string.IsNullOrEmpty(MenuName))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您还未输入菜单名称！");
            return;
        }

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        SystemMenuBean _SystemMenuBean = new SystemMenuBean();
        _SystemMenuBean.MenuName = MenuName;
        _SystemMenuBean.MenuLink = MenuLink;
        _SystemMenuBean.State = State;
        _SystemMenuBean.SortOrder = SortOrder;
        _SystemMenuBean.ParentID = ParentID;
        _SystemMenuBean.EditionID = EditionID;
        bool _Return = false;
        if (SystemMenuID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            _Return = SnSee.Factory.Factory.SystemMenu.Update(_SystemMenuBean, SystemMenuID.Value);
        }
        else
        {//增加
            _Return = SnSee.Factory.Factory.SystemMenu.Insert(_SystemMenuBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}
