﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_User_UserDetail : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? UserBaseID = null;
    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.User))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        } 
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0204", true);
        UserBaseID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ID"]);
        if (!IsPostBack)
        {
            if (UserBaseID.HasValue)
            {
                dropLevel_DataBind();
                LoadUserData(UserBaseID.Value);
            }
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void dropLevel_DataBind()
    {
        dropLevel.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "State=1", "Order By SortOrder Asc, CreateTime Desc");
        dropLevel.DataBind();
    }

    private void LoadUserData(Guid UserBaseID)
    {
        UserBaseBean _UserBaseBean = (UserBaseBean)SnSee.Factory.Factory.UserBase.Select(UserBaseID);
        if (_UserBaseBean != null)
        {
			if(_UserBaseBean.UserLevelID.HasValue)
			{
            	dropLevel.SelectedValue = _UserBaseBean.UserLevelID.Value.ToString();
			}
            txtUserName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.UserName);
            if (_UserBaseBean.Gender.HasValue)
            {
                dropGender.SelectedValue = _UserBaseBean.Gender.Value.ToString();
            }
            txtFullName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.FullName);
            txtCompanyName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.CompanyName);
            txtAddress.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Address);
            txtTel.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Tel);
            txtFax.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Fax);
            txtEmail.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserBaseBean.Email);
            txtPasswordQuestion.Text = _UserBaseBean.PasswordQuestion;
            txtPasswordAnswer.Text = _UserBaseBean.PasswordAnswer;
            if (_UserBaseBean.State.HasValue)
            {
                dropState.SelectedValue = _UserBaseBean.State.Value.ToString();
            }
        }

    }

    protected void lbtnOk_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0203", true);
        UserBaseBean _UserBaseBean = new UserBaseBean();
        _UserBaseBean.UserLevelID = new Guid(dropLevel.SelectedValue);
        _UserBaseBean.UserName = SnSee.Tool.EncodeTool.HtmlEncode(txtUserName.Text);
        if (!string.IsNullOrEmpty(txtUserPwd.Text))
        {
            _UserBaseBean.UserPwd = SnSee.Module.User.User.SetUserPassword(txtUserPwd.Text);
        }
        _UserBaseBean.Gender = SnSee.Tool.ConvertTool.GetInt32(dropGender.SelectedValue);
        _UserBaseBean.FullName = SnSee.Tool.EncodeTool.HtmlEncode(txtFullName.Text);
        _UserBaseBean.CompanyName = SnSee.Tool.EncodeTool.HtmlEncode(txtCompanyName.Text);
        _UserBaseBean.Address = SnSee.Tool.EncodeTool.HtmlEncode(txtAddress.Text);
        _UserBaseBean.Tel = SnSee.Tool.EncodeTool.HtmlEncode(txtTel.Text);
        _UserBaseBean.Fax = SnSee.Tool.EncodeTool.HtmlEncode(txtFax.Text);
        _UserBaseBean.Email = SnSee.Tool.EncodeTool.HtmlEncode(txtEmail.Text);
        _UserBaseBean.PasswordQuestion = txtPasswordQuestion.Text;
        _UserBaseBean.PasswordAnswer = txtPasswordAnswer.Text;
        _UserBaseBean.State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);

        if (SnSee.Factory.Factory.UserBase.Update(_UserBaseBean, UserBaseID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，用户资料保存成功！", "UserList.aspx");
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "用户资料保存失败，请核查！", "UserList.aspx");
        }
    }

}