﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;
using SnSee.Factory;

public partial class Admin_User_UserLevelSet : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private Guid? UserLevelID;
    private string ActionType;

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.User))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0205", true);
        ActionType = Request["AC"];

        UserLevelID = SnSee.Tool.ConvertTool.GetGuid(Request["ID"]);

        if (!IsPostBack)
        {
            if (UserLevelID.HasValue)
            {
                SetUserLevelData(UserLevelID.Value);
            }
            rptList_DataBind();
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    /// <summary>
    /// 载入指定ID的数据
    /// </summary>
    /// <param name="ID">分类ID</param>
    private void SetUserLevelData(Guid ID)
    {
        lbtnAdd.Text = "确定编辑";
        UserLevelBean _UserLevelBean = (UserLevelBean)SnSee.Factory.Factory.UserLevel.Select(ID);
        if (_UserLevelBean != null)
        {
            txtLevelName.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserLevelBean.LevelName);
            txtLevelKey.Text = SnSee.Tool.EncodeTool.HtmlDecode(_UserLevelBean.LevelKey);
            dropState.SelectedValue = _UserLevelBean.State.Value.ToString();
            txtSortOrder.Text = _UserLevelBean.SortOrder.Value.ToString();
        }
    }

    /// <summary>
    /// 载入列表
    /// </summary>
    private void rptList_DataBind()
    {
        rptList.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "", "Order By SortOrder Asc, CreateTime Desc");
        rptList.DataBind();
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? AcUserLevelID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!AcUserLevelID.HasValue)
        {
            return;
        }

        switch (e.CommandName)
        {
            case "Del_CommandName"://删除 
                SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0202", true);
                if (SnSee.Factory.Factory.UserLevel.Delete(AcUserLevelID.Value))
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
                }
                else
                {
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
                }
                break;
        }
    }

    /// <summary>
    /// 确认添加
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnAdd_Click(object sender, EventArgs e)
    {
        string LevelName = SnSee.Tool.EncodeTool.HtmlEncode(txtLevelName.Text);
        string LevelKey = SnSee.Tool.EncodeTool.HtmlEncode(txtLevelKey.Text);
        int? State = SnSee.Tool.ConvertTool.GetInt32(dropState.SelectedValue);
        int? SortOrder = SnSee.Tool.ConvertTool.GetInt32(txtSortOrder.Text);

        if (!State.HasValue)
        {
            State = 1;
        }
        if (!SortOrder.HasValue)
        {
            SortOrder = 0;
        }

        string Where = "LevelKey='" + LevelKey + "'";
        if (UserLevelID.HasValue)
        {
            Where += " And LevelKey<>'" + LevelKey + "'";
        }
        UserLevelBean _UserLevelBeanCheck = (UserLevelBean)SnSee.Factory.Factory.UserLevel.Select(Where);
        if (_UserLevelBeanCheck != null)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已存在相同的标识，请更换另一个后重试操作！");
            return;
        }

        UserLevelBean _UserLevelBean = new UserLevelBean();
        _UserLevelBean.LevelName = LevelName;
        _UserLevelBean.LevelKey = LevelKey;
        _UserLevelBean.State = State;
        _UserLevelBean.SortOrder = SortOrder;

        bool _Return = false;
        if (UserLevelID.HasValue && !string.IsNullOrEmpty(ActionType) && ActionType.ToLower() == "edit")
        {//编辑 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0203", true);
            _Return = SnSee.Factory.Factory.UserLevel.Update(_UserLevelBean, UserLevelID.Value);
        }
        else
        {//增加 
            SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0201", true);
            _Return = SnSee.Factory.Factory.UserLevel.Insert(_UserLevelBean);
        }

        if (_Return)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.Url.ToString());
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.Url.ToString());
        }
    }
}