﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

using SnSee.Bean;

public partial class Admin_User_UserList : System.Web.UI.Page
{
    AdminBaseBean _AdminBeanLogin = null;
    private string Where;
    private Guid? LevelID;
    private string UserName = "";
    private string FullName = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.AdminIsLogin(out _AdminBeanLogin, true);
        if (!SnSee.Module.Admin.Admin.ModuleIsOpen(SnSee.Config.SystemModule.User))
        {
            Response.Redirect("../ErrorTip.aspx?EMsg=该模块尚未开启，如需使用，请联系系统管理员！");
        }

        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0205", true);
        LevelID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["LID"]);
        UserName = Request.QueryString["UserName"];
        FullName = Request.QueryString["FullName"];

        Where = "1=1 ";
        if (!string.IsNullOrEmpty(UserName))
        {
            Where += " And [UserName] Like '%" + UserName + "%'";
        }
        if (!string.IsNullOrEmpty(FullName))
        {
            Where += " And [FullName] Like '%" + FullName + "%'";
        }

        if (LevelID.HasValue)
        {
            Where += " And UserLevelID='{" + LevelID.Value + "}'";
            //SetItem(LevelID.Value);
        }

        if (!IsPostBack)
        {
            txtUserName.Text = UserName;
            txtFullName.Text = FullName;
            dropLevel_DataBind();
            rptList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By CreateTime Desc");
        }
        boxPageExplain.Visible = SnSee.Config.WebConfig.ViewAdminPageExplain;
    }

    private void dropLevel_DataBind()
    {
        dropLevel.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "State=1", "Order By SortOrder Asc, CreateTime Desc");
        dropLevel.DataBind();

        dropLevelSearch.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "State=1", "Order By SortOrder Asc, CreateTime Desc");
        dropLevelSearch.DataBind();

        if (LevelID.HasValue)
        {
            dropLevelSearch.SelectedValue = LevelID.Value.ToString();
        }
    }

    private void rptList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        rptList.DataSource = SnSee.Factory.Factory.UserBase.SelectList(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        rptList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }

    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Guid? UserBaseID = SnSee.Tool.ConvertTool.GetGuid(e.CommandArgument);
        if (!UserBaseID.HasValue || string.IsNullOrEmpty(e.CommandName))
        {
            return;
        }

        DropDownList dropLevel = (DropDownList)e.Item.FindControl("dropLevel");
        switch (e.CommandName.ToLower())
        {
            case "level_command": SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0203", true);
                if (dropLevel != null)
                {
                    UserBaseBean _UserBaseBean = new UserBaseBean();
                    _UserBaseBean.UserLevelID = new Guid(dropLevel.SelectedValue);
                    if (SnSee.Factory.Factory.UserBase.Update(_UserBaseBean, UserBaseID.Value))
                    {
                        SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，操作成功！", Request.RawUrl);
                    }
                } SnSee.Tool.MessageTool.MessageBox(this.Page, "操作失败，请重试！", Request.RawUrl);
                break;
        }
    }

    protected void rptList_ItemDataBound(object source, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            UserBaseBean _UserBaseBean = (UserBaseBean)e.Item.DataItem;
            DropDownList dropLevel = (DropDownList)e.Item.FindControl("dropLevel");
            Literal litLevel = (Literal)e.Item.FindControl("litLevel");

            if (dropLevel != null)
            {
                dropLevel.DataSource = SnSee.Factory.Factory.UserLevel.SelectList(0, "State=1", "Order By SortOrder Asc, CreateTime Desc");
                dropLevel.DataBind();
                if (_UserBaseBean.UserLevelID.HasValue)
                {
                    dropLevel.SelectedValue = _UserBaseBean.UserLevelID.Value.ToString();
                }
            }

            if (litLevel != null && _UserBaseBean.UserLevelID.HasValue)
            {
                UserLevelBean _UserLevelBean = (UserLevelBean)SnSee.Factory.Factory.UserLevel.Select(_UserBaseBean.UserLevelID.Value);
                if (_UserLevelBean != null)
                {
                    litLevel.Text = _UserLevelBean.LevelName;
                }
            }
        }
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnSearch_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserList.aspx?LID=" + dropLevelSearch.SelectedValue + "&UserName=" + txtUserName.Text + "&FullName=" + txtFullName.Text);
    }

    private void SetItem(int Item)
    {
        //switch (Item)
        //{
        //    case 0:
        //        item0.Attributes.Remove("class");
        //        item0.Attributes.Add("class", "item_list_cell_ac margin_left_2px");
        //        break;
        //    case 1:
        //        item1.Attributes.Remove("class");
        //        item1.Attributes.Add("class", "item_list_cell_ac");
        //        break;
        //    case 2:
        //        item2.Attributes.Remove("class");
        //        item2.Attributes.Add("class", "item_list_cell_ac");
        //        break;
        //}
    }

    /// <summary>
    /// 批量处理
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAllLevel_Click(object sender, EventArgs e)
    {
        SnSee.Module.Admin.Admin.ManageIsExist(_AdminBeanLogin, "B0203", true);
        Literal litID;
        CheckBox chkSelect;
        Guid? _UserBaseID = null;
        bool _IsAllOk = true;

        foreach (RepeaterItem row in rptList.Items)
        {
            chkSelect = (CheckBox)row.FindControl("chkSelect");
            litID = (Literal)row.FindControl("litID");
            _UserBaseID = SnSee.Tool.ConvertTool.GetGuid(litID.Text);//取得ID

            if (chkSelect.Checked && _UserBaseID.HasValue)
            {
                UserBaseBean _UserBaseBean = new UserBaseBean();
                _UserBaseBean.UserLevelID = new Guid(dropLevel.SelectedValue);
                if (!SnSee.Factory.Factory.UserBase.Update(_UserBaseBean, _UserBaseID.Value))
                {
                    _IsAllOk = false;
                }
            }
        }

        if (_IsAllOk)
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "恭喜您，已选用户等级设置成功！", Request.RawUrl);
        }
        else
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "已选用户等级设置存在失败，请核查后重试！", Request.RawUrl);
        }
    }
}