﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ArticleList : System.Web.UI.UserControl
{
    /// <summary>
    /// 搜索关键词
    /// </summary>
    private string Keyword;

    /// <summary>
    /// 当前活动
    /// </summary>
    private string ActionType;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 分类标识
    /// </summary>
    private string _ArticleClassKey;
    /// <summary>
    /// 分类标识
    /// </summary>
    public string ArticleClassKey
    {
        get
        {
            if (string.IsNullOrEmpty(_ArticleClassKey))
            {
                if (Request.QueryString["ArticleClassKey"] != null)
                {
                    _ArticleClassKey = Request.QueryString["ArticleClassKey"];
                }
            }
            return _ArticleClassKey;
        }
        set
        {
            _ArticleClassKey = value;
        }
    }

    /// <summary>
    /// 文章分类ID
    /// </summary>
    private Guid? _ArticleClassID;
    /// <summary>
    /// 文章分类ID
    /// </summary>
    private Guid? ArticleClassID
    {
        get
        {
            if (Request.QueryString["ArticleClassID"] != null)
            {
                _ArticleClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ArticleClassID"]);
            }
            return _ArticleClassID;
        }
        set
        {
            _ArticleClassID = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        Keyword = Request.QueryString["Keyword"];   //取得搜索关健词
        ActionType = Request.QueryString["Action"]; //取得当前活动标识

        if (string.IsNullOrEmpty(ActionType) || (!string.IsNullOrEmpty(ActionType) && ActionType.ToLower() != "search"))
        {//只有当当前活动不为搜索时
            if (!ArticleClassID.HasValue)
            {
                if (!string.IsNullOrEmpty(ArticleClassKey))
                {
                    SnSee.Bean.ArticleClassBean _ArticleClassBean = (SnSee.Bean.ArticleClassBean)SnSee.Factory.Factory.ArticleClass.Select("ClassKey='" + ArticleClassKey + "'");
                    if (_ArticleClassBean != null)
                    {
                        ArticleClassID = _ArticleClassBean.ID;  //如果指定了分类标识key，则取得对应的分类ID
                    }
                }
            }

            if (!ArticleClassID.HasValue && _EditionBean != null)
            {//如果不存在文章分类ID,则取排序为第一的文章分类ID
                List<object> _ArticleClassBeanList = SnSee.Factory.Factory.ArticleClass.SelectList(1, "State=1 And IsChild=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
                if (_ArticleClassBeanList != null && _ArticleClassBeanList.Count > 0)
                {
                    SnSee.Bean.ArticleClassBean _ArticleClassBean = (SnSee.Bean.ArticleClassBean)_ArticleClassBeanList[0];
                    if (_ArticleClassBean != null)
                    {
                        ArticleClassID = _ArticleClassBean.ID;
                    }
                }
            }
        }

        string Where = "ArticleBase.[State]=1";//查询条件
        if (_EditionBean != null)
        {
            Where += " And ArticleClass.EditionID='{" + _EditionBean.ID.Value + "}'";
        }
        if (ArticleClassID.HasValue)
        {
            Where += " And (ArticleClass.ID='{" + ArticleClassID.Value + "}' Or ArticleClass.DepthPath Like '%" + ArticleClassID.Value + "%')";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.StringTool.FilterString(Keyword);
            Where += " And ArticleBase.Title Like '%" + Keyword + "%'";
        }
        ArticleList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By ArticleBase.SortOrder Asc, ArticleBase.CreateTime Desc");
    }

    /// <summary>
    /// 取得文章列表
    /// </summary>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void ArticleList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        ArticleList.DataSource = SnSee.Factory.Factory.ArticleBase.GetArticleListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        ArticleList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }
}
