﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_Links : System.Web.UI.UserControl
{
    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        if (_EditionBean != null)
        {
            LinkListImg_DataBind(0, "State=1 And IsImage=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc, CreateTime Asc");
            LinkListText_DataBind(0, "State=1 And (IsImage=0 Or IsImage Is Null) And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc, CreateTime Asc");
        }
    }

    /// <summary>
    /// 取得列表-图片LOGO方式
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void LinkListImg_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        LinkListImg.DataSource = SnSee.Factory.Factory.LinkBase.SelectList(_MaxNum, _Where, _OrderBy);
        LinkListImg.DataBind();
    }

    /// <summary>
    /// 取得列表-文字方式
    /// </summary>
    /// <param name="_MaxNum">最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void LinkListText_DataBind(int _MaxNum, string _Where, string _OrderBy)
    {
        LinkListText.DataSource = SnSee.Factory.Factory.LinkBase.SelectList(_MaxNum, _Where, _OrderBy);
        LinkListText.DataBind();
    }
}
