﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Cn_Controls_LoginView : System.Web.UI.UserControl
{
    private string BackUrl;
    protected void Page_Load(object sender, EventArgs e)
    {
        BackUrl = Request.QueryString["BackUrl"];
    }

    /// <summary>
    /// 登陆
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        string UserName = txtUserName.Text;
        string UserPwd = txtUserPwd.Text;

        if (string.IsNullOrEmpty(UserName) || string.IsNullOrEmpty(UserPwd))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您還未輸入用戶或密碼！");
            return;
        }

        int Flag = 0;
        //执行登陆
        if (SnSee.Module.User.User.UserLogin(UserName, UserPwd, 720, out Flag))
        {//登陆成功 
            if (!string.IsNullOrEmpty(BackUrl))
            {
                Response.Redirect(SnSee.Tool.EncodeTool.FromBase64CodeString(BackUrl));
            }
            else
            {
                Response.Redirect("/Cn/UserCenter.aspx");
            }
        }
        else
        {
            switch (Flag)
            {
                case 2:
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "您的用戶已被禁用，請聯係我們！");
                    break;
                default:
                    SnSee.Tool.MessageTool.MessageBox(this.Page, "登陸失敗，請核對您輸入的用戶和密碼！");
                    break;
            }
            return;
        }
    }

    /// <summary>
    /// 注册
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnReg_Click(object sender, EventArgs e)
    {
        Response.Redirect("UserRegister.aspx");
    }
}
