﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using SnSee.Bean;

public partial class Cn_Controls_ProductList : System.Web.UI.UserControl
{
    /// <summary>
    /// 搜索关键词
    /// </summary>
    private string Keyword;

    /// <summary>
    /// 当前活动
    /// </summary>
    private string ActionType;

    /// <summary>
    /// 语言版本标识
    /// </summary>
    private string _EditionKey;
    /// <summary>
    /// 语言版本标识
    /// </summary>
    public string EditionKey
    {
        get
        {
            if (string.IsNullOrEmpty(_EditionKey))
            {
                if (Request.QueryString["EditionKey"] != null)
                {
                    _EditionKey = Request.QueryString["EditionKey"];
                }
                else if (!string.IsNullOrEmpty(SnSee.Config.WebConfig.EditionKey))
                {
                    _EditionKey = SnSee.Config.WebConfig.EditionKey;
                }
            }
            return _EditionKey;
        }
        set
        {
            _EditionKey = value;
        }
    }

    /// <summary>
    /// 分类标识
    /// </summary>
    private string _ProductClassKey;
    /// <summary>
    /// 分类标识
    /// </summary>
    public string ProductClassKey
    {
        get
        {
            if (string.IsNullOrEmpty(_ProductClassKey))
            {
                if (Request.QueryString["ProductClassKey"] != null)
                {
                    _ProductClassKey = Request.QueryString["ProductClassKey"];
                }
            }
            return _ProductClassKey;
        }
        set
        {
            _ProductClassKey = value;
        }
    }

    /// <summary>
    /// 产品分类ID
    /// </summary>
    private Guid? _ProductClassID;
    /// <summary>
    /// 产品分类ID
    /// </summary>
    private Guid? ProductClassID
    {
        get
        {
            if (Request.QueryString["ProductClassID"] != null)
            {
                _ProductClassID = SnSee.Tool.ConvertTool.GetGuid(Request.QueryString["ProductClassID"]);
            }
            return _ProductClassID;
        }
        set
        {
            _ProductClassID = value;
        }
    }

    private SnSee.Bean.UserBaseBean _UserBaseBean = null;

    protected void Page_Load(object sender, EventArgs e)
    {
        EditionBean _EditionBean = null;
        if (!string.IsNullOrEmpty(EditionKey))
        {
            _EditionBean = (EditionBean)SnSee.Factory.Factory.Edition.Select("EditionKey='" + EditionKey + "' And State=1");
        }

        Keyword = Request.QueryString["Keyword"];   //取得搜索关健词
        ActionType = Request.QueryString["Action"]; //取得当前活动标识

        if (string.IsNullOrEmpty(ActionType) || (!string.IsNullOrEmpty(ActionType) && ActionType.ToLower() != "search"))
        {//只有当当前活动不为搜索时
            if (!ProductClassID.HasValue)
            {
                if (!string.IsNullOrEmpty(ProductClassKey))
                {
                    SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)SnSee.Factory.Factory.ProductClass.Select("ClassKey='" + ProductClassKey + "'");
                    if (_ProductClassBean != null)
                    {
                        ProductClassID = _ProductClassBean.ID;  //如果指定了分类标识key，则取得对应的分类ID
                    }
                }
            }

            if (!ProductClassID.HasValue && _EditionBean != null)
            {//如果不存在产品分类ID,则取排序为第一的产品分类ID
                List<object> _ProductClassBeanList = SnSee.Factory.Factory.ProductClass.SelectList(1, "State=1 And IsChild=-1 And EditionID='{" + _EditionBean.ID.Value + "}'", "Order By SortOrder Asc");
                if (_ProductClassBeanList != null && _ProductClassBeanList.Count > 0)
                {
                    SnSee.Bean.ProductClassBean _ProductClassBean = (SnSee.Bean.ProductClassBean)_ProductClassBeanList[0];
                    if (_ProductClassBean != null)
                    {
                        ProductClassID = _ProductClassBean.ID;
                    }
                }
            }
        }
        SnSee.Module.User.User.UserIsLogin(out _UserBaseBean, false, null);
        if (!SnSee.Module.Product.ProductBase.CheckViewUserLevel(_UserBaseBean, ProductClassID, null, _EditionBean.ID.Value))
        {
            SnSee.Tool.MessageTool.MessageBox(this.Page, "您沒有許可權訪問當前頁面！", "Login.aspx");
            return;
        }

        string Where = "ProductList.[State]=1";//查询条件
        if (_EditionBean != null)
        {
            Where += " And ProductList.EditionID='{" + _EditionBean.ID.Value + "}'";
        }

        if (ProductClassID.HasValue)
        {//如果存在产品ID
            Where += " And (ProductClass.ID='{" + ProductClassID.Value + "}' Or ProductClass.DepthPath Like '%" + ProductClassID.Value + "%')";
        }
        if (!string.IsNullOrEmpty(Keyword))
        {
            Keyword = SnSee.Tool.StringTool.FilterString(Keyword);
            Where += " And (ProductList.Model Like '%" + Keyword + "%' Or ProductList.Name Like '%" + Keyword + "%')";
        }
        ProductList_DataBind(WebPage1.PageIndex, WebPage1.PageSize, Where, "Order By ProductList.SortOrder Asc, ProductList.CreateTime Desc");
    }

    /// <summary>
    /// 取得产品列表
    /// </summary>
    /// <param name="_PageIndex">当前页码</param>
    /// <param name="_PageSize">一页最大条数</param>
    /// <param name="_Where">条件</param>
    /// <param name="_OrderBy">排序方式</param>
    private void ProductList_DataBind(int _PageIndex, int _PageSize, string _Where, string _OrderBy)
    {
        int _RowCount = 0;
        ProductList.DataSource = SnSee.Factory.Factory.ProductBase.GetProductListPage(_PageIndex, _PageSize, _Where, _OrderBy, out _RowCount);
        ProductList.DataBind();
        WebPage1.RecordCount = _RowCount;
    }
}
